﻿#include "tasklogin.h"
#include "fmviplogin.h"
#include "fmp_vip_settings.h"
#include "fmnetwork.h"
#include <QJsonDocument>

TaskLogin::TaskLogin(QJsonObject &jsonObj, Session *session, QObject *parent)
    :FMTask(jsonObj, FM_Login, session, parent)
{
}

void TaskLogin::setWindow()
{
    _window = new FMVipLogin;

    connect(qobject_cast<FMVipLogin*>(_window), &FMVipLogin::login, this, &TaskLogin::onLogin);
}

void TaskLogin::packageServerReq()
{
    QJsonObject code;
    code[ServerProps(PosProps.Member_sign)] = session()->data(PosProps.Member_sign).toString();
    serverReqJsonObj["data"] = code;
}

void TaskLogin::packagePOSRsp()
{
    std::vector<QString> p;
    p.push_back(PosProps.StatusCode);
    p.push_back(PosProps.Msg);
    p.push_back(PosProps.Fm_open_id);
    foreach (QString prop , p) {
        posRspJsonObj[prop] = getServerJsonValue(prop);
    }
    posRspJsonObj[PosProps.Prompt] = 0;
}

void TaskLogin::onLogin()
{
    bool isOk = sendToServer();
    if(!isOk) {
        if(_window != nullptr) {
            _window->accept();
        }
        return;
    }

    // 认证失败
    if(getServerJsonValue("statusCode").toInt() != FM_API_SUCCESS) {
        QString info = serverRspJsonObj["msg"].toString();
        FMP_WARN() << "Login failed: " << info;
        FMMsgWnd::FailureWnd(info, _window);
    }
    // 认证成功
    else {
        QString account = getServerJsonValue(PosProps.Fm_open_id).toString();
        QString birthday = getServerJsonValue(PosProps.Birthday).toString();
        if(birthday.isEmpty()) {
            birthday = "--";
        }
        QString name = getServerJsonValue(PosProps.Name).toString();
        if(name.isEmpty()) {
            name = "--";
        }

        bool canPay = (getServerJsonValue(PosProps.CanPay).toInt() == 1);
#ifdef TEST
        canPay = true;
#endif
        if(!canPay) {
            if(getPosJsonValue(PosProps.Fm_cmd).toInt() != FM_Pay) {
                FMMsgWnd::LoginSuccess(account, name, birthday, _window);
            } else {
                FMMsgWnd::FailureWnd(QString::fromLocal8Bit(ErrorNeedPayCode), _window);
                _window->resetWnd();
                return;
            }
        }

        session()->addData(PosProps.Name, name);
        session()->addData(PosProps.Birthday, birthday);
        session()->addData(PosProps.Fm_open_id, account);
        session()->addData(PosProps.Amount, getServerJsonValue(PosProps.Amount).toInt());
        session()->addData(PosProps.Score, getServerJsonValue(PosProps.Score).toInt());
        session()->addData(PosProps.CanPay, canPay);

        _window->accept();
    }
    if(_window!=nullptr) {
        _window->resetWnd();
    }
}
