﻿#include "taskfund.h"
#include "fmvipfund.h"
#include "tasklogin.h"

TaskFund::TaskFund(QJsonObject &jsonObj, QObject *parent)
    :FMTask(jsonObj, FM_Fund, 0, parent)
{

}

QByteArray TaskFund::doTask()
{
    preTask = new TaskLogin(posReqJsonObj, _session, this);
    preTask->session()->addData(PosProps.FM_Type, FM_Fund);
    QByteArray loginRst = preTask->doTask();
    if(preTask->error() != FM_API_SUCCESS) {
        return loginRst;
    }
    return FMTask::doTask();
}

void TaskFund::setWindow()
{
    _window = new FMVipFund;

    connect(qobject_cast<FMVipFund*>(_window), SIGNAL(fund()), this, SLOT(onFund()));

    session()->addData(PosProps.ChargeAmount, getPosJsonValue(PosProps.ChargeAmount));
}

void TaskFund::packageServerReq()
{
    serverReqJsonObj[ServerProps(PosProps.TransId)] = getPosJsonValue(PosProps.TransId);
    QJsonObject trans;
    trans[ServerProps(PosProps.Fm_open_id)] = session()->data(PosProps.Fm_open_id).toString();
    trans[ServerProps(PosProps.ChargeAmount)] = session()->data(PosProps.ChargeAmount).toInt();
    trans[ServerProps(PosProps.CashAmount)] = session()->data(PosProps.ChargeAmount).toInt();
    serverReqJsonObj[ServerProps(PosProps.Transaction)] = trans;
}

void TaskFund::packagePOSRsp()
{
    std::vector<QString> p;
    p.push_back(PosProps.StatusCode);
    p.push_back(PosProps.Msg);
    p.push_back(PosProps.Fm_id);
    p.push_back(PosProps.Print);
    foreach (QString prop , p) {
        posRspJsonObj[prop] = getServerJsonValue(prop);
    }
    posRspJsonObj[PosProps.Prompt] = 1;
    posRspJsonObj[PosProps.Fm_open_id] = session()->data(PosProps.Fm_open_id).toString();
}

void TaskFund::onFund()
{
    sendToServer();
    _window->close();
}
