﻿#include "taskfinal.h"
#include "fmbackup.h"
#include "fmnetwork.h"
#include "fmp_logger_i.h"
#include "fmmsgwnd.h"
#include "fmp_vip_settings.h"
#include <QDateTime>
#include <QJsonDocument>
#include <QJsonArray>
#include <QCryptographicHash>

TaskFinal::TaskFinal(QJsonObject &jsonObj, Session *session, QObject *parent)
    :FMTaskNoWnd(jsonObj, FM_Final, session, parent)
{
}

void TaskFinal::packageServerReq()
{
    isUseVipPay = false;
    QJsonObject transData;
    std::vector<QString> p;
    p.push_back(PosProps.BussinessDate);
    p.push_back(PosProps.TransId);
    p.push_back(PosProps.Fm_id);
    p.push_back(PosProps.Fm_open_id);
    foreach(auto prop , p) {
        transData[ServerProps(prop)] = getPosJsonValue(prop);
    }

    // 产品列表
    QJsonArray products;
    foreach(auto p , getPosJsonValue("products").toArray())
    {
        QJsonObject product;
        product[ServerProps(PosProps.ConsumeNum)] = p.toObject()[PosProps.ConsumeNum];
        int price = p.toObject()["price"].toInt();
        product["price"] = price;
        product["productId"] = p.toObject()["pid"];
        
        products.append(product);
    }
    transData["productList"] = products;

    int orderAmount = getPosJsonValue(PosProps.OrderAmount).toInt();
    int paidAmount = getPosJsonValue(PosProps.PaidAmount).toInt();

    QJsonArray payList;

//    QString fmId = getPosJsonValue(PosProps.Fm_id).toString();
//    QByteArray orderContent = FMBackup::instance()->getOrderByFmId(fmId);
//    QJsonObject orderObject = QJsonDocument::fromJson(orderContent).object();
//    QJsonArray payArray = searchJsonValue(orderObject, "payList").toArray();
//    foreach (auto pay_v, payArray) {
//        QJsonObject pay_ob = pay_v.toObject();
//        if(pay_ob["typeModeFlag"].toString() == "20003") {
//            payList.append(pay_ob);
//            isUseVipPay = true;
//            int pay_amount = pay_ob["amount"].toInt();
//            orderAmount += pay_amount;
//            paidAmount += pay_amount;
//        }
//    }
    transData[ServerProps(PosProps.OrderAmount)] = orderAmount;
    transData[ServerProps(PosProps.PaidAmount)] = paidAmount;

    foreach(auto p, getPosJsonValue(PosProps.Pay_ids).toArray())
    {
        QJsonObject pay;
        pay["amount"] = p.toObject()["pay_amount"];
        pay["thirdPayTransId"] = p.toObject()["pay_transId"].toString();
        pay["code"] = p.toObject()["code"].toString();
        pay[ServerProps(PosProps.TransId)] = getPosJsonValue(PosProps.TransId);
        QString typeModeFlag = p.toObject()["pay_id"].toString();
        if(typeModeFlag == "0101") {
            //现金支付
            pay["typeModeFlag"] = "20005";
        } else if(typeModeFlag == "0301") {
            pay["typeModeFlag"] = "10011";
        } else if(typeModeFlag == "0302") {
            pay["typeModeFlag"] = "10011";
        } else if(typeModeFlag == "0303") {
            pay["typeModeFlag"] = "10011";
        } else {
            pay["typeModeFlag"] = typeModeFlag;
        }

        if(typeModeFlag.compare("20001")==0 || typeModeFlag.compare("20002")==0 || typeModeFlag.compare("20003")==0) {
            isUseVipPay = true;
        }
        
        payList.append(pay);
    }



    transData["payList"] = payList;
    serverReqJsonObj["data"] = transData;
}

bool TaskFinal::sendToServer(bool isShowMsg)
{
    Q_UNUSED(isShowMsg);
    FMTask::sendToServer(false);
    
    // 备份
    if(error() == FM_API_NETWORERROR || error() == FM_API_TIMEOUT) {
        if(!isUseVipPay) {
            QString fm_id = backup();
            if(!fm_id.isEmpty()){
                setError(FM_API_SUCCESS);
                serverRspJsonObj[ServerProps(PosProps.StatusCode)] = FM_API_SUCCESS;
                serverRspJsonObj[ServerProps(PosProps.Msg)] = QString::fromLocal8Bit("结算成功");
                serverRspJsonObj[ServerProps(PosProps.Fm_id)] = fm_id;
                serverRspJsonObj[ServerProps(PosProps.Prompt)] = 1;
                serverRspJsonObj[ServerProps(PosProps.Print1)] = "";
                serverRspJsonObj[ServerProps(PosProps.Print2)] = "";
            }
        }
    }
    bool isOk = (error() == FM_API_SUCCESS);
    if(!isOk)
    {
        FMMsgWnd::FailureWnd(errorString(), _window);
    }
    return isOk;
}

void TaskFinal::packagePOSRsp()
{
    std::vector<QString> p;
    p.push_back(PosProps.StatusCode);
    p.push_back(PosProps.Msg);
    p.push_back(PosProps.Fm_id);
    p.push_back(PosProps.Print1);
    p.push_back(PosProps.Print2);
    foreach(auto prop , p)
    {
        posRspJsonObj[prop] = getServerJsonValue(prop);
    }
    posRspJsonObj[PosProps.Prompt] = 1;
}

QString TaskFinal::backup()
{
    int newId = FMBackup::instance()->insertNewRow();
    QString uuid = QString("E%1%2%3%4")
            .arg(getPosJsonValue(PosProps.StoreId).toString())
            .arg(getPosJsonValue(PosProps.PosId).toString().toInt(), 2, 10, QChar('0'))
            .arg(QDateTime::currentDateTime().toString("yyMMddhhmmsszzz"))
            .arg(newId, 5, 10, QChar('0'));
    QJsonDocument json(serverReqJsonObj);
    bool isOk = FMBackup::instance()->updateReqData(newId, this->url, json.toJson(QJsonDocument::Compact));
    if(isOk) {
        return uuid;
    }
    return "";
}
