﻿#ifndef COUPON_H
#define COUPON_H

#include <QVariant>
#include <QString>
#include <QPolygonF>

class QPainter;

class Coupon
{
public:
    explicit Coupon(QString name="", QString code="", QString type="", double disAmount=0, double limitAmount=0, QString limitTime="", bool isCompatible=true);

    void paint(QPainter *painter, const QRect &rect,
               const QPalette &palette) const;
    QSize sizeHint() const;

    QString name() const {return _name;}
    QString code() const {return _code;}
    QString typeModeFlag() const {return _type;}
    double disAmount() const {return _disAmount;}
    double limitAmount() const {return _limitAmount;}
    bool isCompatible() const {return _isCompatible;}
private:
    QString _name;
    QString _code;
    QString _type;
    double _disAmount;
    double _limitAmount;
    bool _isCompatible;
    QString _limitTime;
};

Q_DECLARE_METATYPE(Coupon)

#endif // COUPON_H
