#ifndef PAY_H
#define PAY_H
#include "item.h"
#include "global.h"

namespace FMItem {

    class Pay : public Item
    {
        Q_OBJECT

        Q_PROPERTY(QString pay_id READ payId WRITE setPayId)
        Q_PROPERTY(QString pay_str READ payStr WRITE setPayStr)
        Q_PROPERTY(int pay_amount READ payAmount WRITE setPayAmount)
        Q_PROPERTY(int discount_amount READ disAmount WRITE setDisAmount)
        Q_PROPERTY(QString account READ account WRITE setAccount)
        Q_PROPERTY(QString trans_id READ transId WRITE setTransId)
        Q_PROPERTY(QString payTransId READ payTransId WRITE setPayTransId)
        Q_PROPERTY(int orderId READ orderId WRITE setOrderId)
    public:
        explicit Pay(QObject *parent = 0);

        QString payId() const;
        void setPayId(const QString &payId);

        QString payStr() const;
        void setPayStr(const QString &payStr);

        int payAmount() const;
        void setPayAmount(int payAmount);

        int disAmount() const;
        void setDisAmount(int disAmount);

        QString account() const;
        void setAccount(const QString &account);

        QString transId() const;
        void setTransId(const QString &transId);

        QString payTransId() const;
        void setPayTransId(const QString &payTransId);

        int orderId() const;
        void setOrderId(int orderId);

    private:
        QString _payId;
        QString _payStr;
        int _payAmount;
        int _disAmount;

        QString _account;
        QString _transId;
        QString _payTransId;

        int _orderId;
    };
}

#endif // PAY_H
