#ifndef ORDER_H
#define ORDER_H

#include "item.h"
#include <QList>
#include <QJsonObject>

namespace FMItem {

    class Pay;
    class Product;

    typedef QList<Pay *> PayList;
    typedef QList<Product *> ProductList;

    class Order : public Item
    {
        Q_OBJECT

        Q_PROPERTY(QString trans_id READ transId WRITE setTransId)
        Q_PROPERTY(QString fm_id READ fmId WRITE setFmId)
        Q_PROPERTY(int order_amount READ orderAmount WRITE setOrderAmount)
        Q_PROPERTY(int paid_amount READ paidAmount WRITE setPaidAmount)
        Q_PROPERTY(int undis_amount READ undisAmount WRITE setUndisAmount)
        Q_PROPERTY(QString store_id READ storeId WRITE setStoreId)
        Q_PROPERTY(QString pos_id READ posId WRITE setPosId)
        Q_PROPERTY(QString operator_id READ operatorId WRITE setOperatorId)
        Q_PROPERTY(QString business_date READ businessDate WRITE setBusinessDate)
        Q_PROPERTY(QString fm_open_id READ fmOpenId WRITE setFmOpenId)
        Q_PROPERTY(QString products READ productText WRITE setProductText)
        Q_PROPERTY(bool settled READ settled WRITE setSettled)
//        Q_PROPERTY(ItemList payList READ payList WRITE setPayList)
//        Q_PROPERTY(ProductList productList READ productList WRITE setProductList)
    public:
        explicit Order(QObject *parent = 0);

        QString transId() const;
        void setTransId(const QString &transId);

        QString fmId() const;
        void setFmId(const QString &fmId);

        int orderAmount() const;
        void setOrderAmount(int orderAmount);

        int paidAmount() const;
        void setPaidAmount(int paidAmount);

        int undisAmount() const;
        void setUndisAmount(int undisAmount);

        QString storeId() const;
        void setStoreId(const QString &storeId);

        QString posId() const;
        void setPosId(const QString &posId);

        QString operatorId() const;
        void setOperatorId(const QString &operatorId);

        QString businessDate() const;
        void setBusinessDate(const QString &businessDate);

        QString fmOpenId() const;
        void setFmOpenId(const QString &fmOpenId);

        ItemList payList() const;
        void setPayList(const ItemList &payList);

        ProductList productList() const;
        void setProductList(const ProductList &productList);

        QString productText() const;
        void setProductText(const QString &productText);

        bool settled() const;
        void setSettled(bool settled);

    private:
        QString _transId;
        QString _fmId;
        int _orderAmount;
        int _paidAmount;
        int _undisAmount;

        QString _storeId;
        QString _posId;
        QString _operatorId;
        QString _businessDate;
        QString _fmOpenId;

        QString _productText;

        bool _settled;

        ItemList _payList;
        ProductList _productList;
    };
}

#endif // ORDER_H
