#include "item.h"
#include "global.h"
#include <QMetaProperty>
#include <QJsonArray>
#include <QJsonDocument>
#include <QDebug>

using namespace FMItem;

Item::Item(QObject *parent)
    : QObject(parent)
    , _DBID(0)
{

}


Item::Item(const QJsonObject &json, QObject *parent)
    : QObject(parent)
{
    this->SetPropertiesByJson(json);
}

void Item::SetPropertiesByJson(const QJsonObject &json)
{
    foreach(const QString &key, json.keys()) {
        QJsonValue jsonValue = json[key];
        QVariant value;

        if(jsonValue.isArray()) {
//            ItemList itemList;
//            foreach (QJsonValue arrayJson, jsonValue.toArray()) {
//                itemList.append(new Item(arrayJson.toObject(), this));
//            }
            //! TODO 实现转换array

            // 将商品信息转成字符串存储
            if(key.compare(PosProps.Products) == 0) {
                value = QJsonDocument(jsonValue.toArray()).toJson(QJsonDocument::Compact);
            }
        } else if(jsonValue.isObject()) {
            SetPropertiesByJson(jsonValue.toObject());
        }else {
            value = jsonValue.toVariant();
        }

        this->setProperty(key.toUtf8().data(), value);
    }
}

void Item::SetPropertiesByJson(const QByteArray &json)
{
    QJsonObject jsonObj = QJsonDocument::fromJson(json).object();
    SetPropertiesByJson(jsonObj);
}

void Item::SetPropertiesBySqlRecord(const QSqlRecord &record)
{
    foreach (const QString &property, this->PropertyNames()) {
        if(record.contains(property)) {
            this->setProperty(property.toUtf8().data(), record.value(property));
        }
    }
    this->setDBID(record.value("id").toInt());
}

QJsonObject Item::toJson(QStringList keys, QJsonObject json)
{
    if(keys.isEmpty()) {
        foreach (const QString &property, this->PropertyNames()) {
            QVariant value = this->property(property.toUtf8().data());
            json[property] = QJsonValue::fromVariant(value);
        }
    } else {
        foreach (const QString &property, keys) {
            QVariant value = this->property(property.toUtf8().data());
            json[property] = QJsonValue::fromVariant(value);
        }
    }

    return json;
}

QJsonObject Item::toJson(QMap<QString, QString> key2property, QJsonObject json)
{
    for(QMap<QString, QString>::const_iterator it=key2property.constBegin(); it!=key2property.constEnd(); it++) {
        QVariant value = this->property(it.value().toUtf8().data());
        json[it.key()] = QJsonValue::fromVariant(value);
    }
    return json;
}

int Item::PropertyCount() const
{
    return this->metaObject()->propertyCount();
}

QStringList Item::PropertyNames() const
{
    QStringList propertyNames;
    for(int i=0; i<this->PropertyCount(); i++) {
        QMetaProperty metaProperty = this->metaObject()->property(i);
        propertyNames << metaProperty.name();
    }
    return propertyNames;
}

int Item::DBID() const
{
    return _DBID;
}

void Item::setDBID(int DBID)
{
    _DBID = DBID;
}

QString Item::ShortClassName() const
{
    QString className(this->metaObject()->className());
    className = className.remove(0, className.lastIndexOf(":")+1);
    return className;
}

bool Item::isEqual(const Item *other)
{
    bool flag = (other != NULL);
    flag &= (this->PropertyNames() == other->PropertyNames());
    if(flag) {
        foreach (const QString &p, PropertyNames()) {
            if(this->property(p.toUtf8().data()) != other->property(p.toUtf8().data())) {
                flag = false;
                break;
            }
        }
    }
    return flag;
}

bool Item::isNew()
{
    return (_DBID <= 0);
}
