#ifndef FMTOOL_H
#define FMTOOL_H

#include <QJsonObject>

static QJsonValue SearchJsonValue(const QJsonObject &searchJson, const QString &searchKey)
{
    if(searchJson.contains(searchKey)) {
        return searchJson[searchKey];
    } else {
        foreach(QString key , searchJson.keys()) {
            if(searchJson[key].isObject()) {
                QJsonObject ob = searchJson[key].toObject();
                QJsonValue value = SearchJsonValue(ob, searchKey);
                if(!value.isNull()){
                    return value;
                }
            }
        }
    }
    return QJsonValue();
}

#endif // FMTOOL_H
