﻿#include "fmp_vip_settings.h"
#include <fmp_settings_i.h>
#include <QDebug>

FMPVipSettings::FMPVipSettings(QObject *parent) : QObject(parent)
{
}

FMPVipSettings *FMPVipSettings::instance()
{
    static FMPVipSettings vipSettings;
    return &vipSettings;
}

void FMPVipSettings::init(FMPSettingsInterface *settings)
{
    this->_settings = settings;
}

QString FMPVipSettings::getServerUrl()
{
    return _GetValue(FMP_INIKEY_VIPSERVER).toString();
}

bool FMPVipSettings::getIsNeedSocketHeader()
{
    return _GetValue(FMP_INIKEY_NEEDSOCKETHEADER, false).toBool();
}

QVariant FMPVipSettings::_GetValue(const QString &key, QVariant defaultValue)
{
    if (_settings) {
        return _settings->GetValue(key);
    }
    else {
        FMP_WARN() << "Settings service not available";
    }

    return defaultValue;
}

bool FMPVipSettings::_SetValue(const QString &key, QVariant value)
{
    if (_settings) {
        _settings->SetValue(key, value);
        return true;
    }
    else {
        FMP_WARN() << "Settings service not available";
    }

    return false;
}
