#ifndef FMP_DATABASE_H
#define FMP_DATABASE_H

#include <QObject>
#include <QSqlDatabase>

class FMPLoggerInterface;
class QSqlQuery;
class QSqlDatabase;

class FMPDataBase : public QObject
{
    Q_OBJECT
public:
    FMPDataBase(QString dbname, QString connectname = QString("fmvipdbop"), QObject *parent = 0);

    ~FMPDataBase();

    bool insert(QString table, QVariantHash data);

    bool update(QString table, QVariantHash data, QString condition);

    bool find(QString table, QSqlQuery &query, QStringList keylist = QStringList(), QString condition = QString(""));

    bool creat(QString sql);

    bool dlt(QString table, QString condition);

    QSqlDatabase getDb() const;

private:

    bool exist(QString table);

    bool getSql(QString table, QVariantHash data, QString &sql);

    bool getSql(QString table, QVariantHash data, QStringList &columnnamelist, QStringList &columnvaluelist);

private:

    QSqlDatabase _db;

    bool _isopen;
};

#endif // FMP_DATABASE_H
