#ifndef DBOP_H
#define DBOP_H

#include <QObject>
#include <QVector>
#include "global.h"

#define TABLE_PAY      "Pay"
#define TABLE_ORDER    "Order"

namespace FMItem {
class Item;
class Order;
class Pay;
}

class FMPDataBase;

class DBOP
{
public:
    static DBOP *Instance();

    static bool Save(FMItem::Item *item);

    static void InsertTablePay(const QString &transId, const QString &fmId, const QByteArray &reqData, const QByteArray &rspData);
    static void InsertTableOrder(const QString &transId, const QString &fmId, const QByteArray &reqData, const QByteArray &rspData);

    static void GetPaysByTransId(const QString &transId, QVector<QByteArray> &payDataVec);

    static void GetOrderByTransId(const QString &transId, FMItem::Order *order);
    static QSharedPointer<FMItem::Order> GetOrderByTransId(const QString &transId);

    static QList<QSharedPointer<FMItem::Pay> > GetPaysByOrderId(int orderId);
private:
    DBOP();
    FMPDataBase *_db;

    static void InserTable(const QString &tableName, const QString &transId, const QString &fmId, const QByteArray &reqData, const QByteArray &rspData);

    bool CreateTable(const QString &tableName);
    bool ExistTable(const QString &tableName);

    int GetLastInsertId();
};

#endif // DBOP_H
