﻿/*=============================================================================

  Library: CTK

  Copyright (c) German Cancer Research Center,
    Division of Medical and Biological Informatics

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

=============================================================================*/


#include "fmp_vip_plugin_p.h"

#include "fmp_vip.h"

#include <QtPlugin>
#include <QStringList>
#include <QDebug>

FMPVipPlugin::FMPVipPlugin()
  : _vip_service(0)
{
}

void FMPVipPlugin::start(ctkPluginContext* context)
{
  _vip_service = new FMPVip(context);
  context->registerService<FMPVipInterface>( _vip_service);
}

void FMPVipPlugin::stop(ctkPluginContext* context)
{
  Q_UNUSED(context)
  if (_vip_service)
  {
    delete _vip_service;
    _vip_service = 0;
  }
}

#if (QT_VERSION < QT_VERSION_CHECK(5,0,0))
Q_EXPORT_PLUGIN2(fmp_vip, FMPVipPlugin)
#endif
