﻿#include "fmp_vip_p.h"
#include <fmp_settings_i.h>
#include <fmp_home_i.h>
#include <QCoreApplication>
#include <QDateTime>
#include <ctkPluginContext.h>
#include <ctkServiceReference.h>
#include "fmp_vip_server.h"
#include "fmp_vip_settings.h"
#include "fmp_logger_i.h"
#include "resend.h"
#include <QDebug>

FMPVipPrivate::FMPVipPrivate(FMPVip *vip):
    q_ptr(vip)
{
}

int FMPVipPrivate::Init()
{
    Q_Q(FMPVip);
    FMPHomeInterface *home = q->GetService<FMPHomeInterface>(q->_ctx);
    if(q->_inited) {
        home->notification(QString::fromLocal8Bit("[非码会员]已在运行！"));
    } else {
        _settings = q->GetService<FMPSettingsInterface>(q->_ctx);
        FMPVipSettings::instance()->init(_settings);

        auto resend = new ReSend();
        resend->start();
        FMPVipServer::instance()->SetPluginContext(q->_ctx);

        q->_inited = true;

        home->notification(QString::fromLocal8Bit("[非码会员]启动成功！"));

        FMP_INFO() << "Vip start";
    }

    return FMP_SUCCESS;
}

int FMPVipPrivate::Uninit()
{
    Q_Q(FMPVip);

    //! Clean up
    q->_inited = false;
    return FMP_SUCCESS;
}
