﻿#include "fmpinittask.h"
#include <QCoreApplication>
#include <QResource>
#include "QsLog/QsLog.h"
#include <QDir>
#include <QDebug>
#include <QCoreApplication>
#include <preDefine.h>
#include <Control/flowControl.h>
#include <Control/sinfoControl.h>
#include <DTools/configManger.h>
using namespace QsLogging;

FMPInitTask::FMPInitTask(QObject *parent) : QObject(parent)
{
    g_appDir=QCoreApplication::applicationDirPath();
    mainForm=new MainForm();
    floatForm=new FloatForm();
}

void FMPInitTask::LoadLogger()
{
    QString logDir = QString("%1/log").arg(g_appDir);
    Logger& logger = Logger::instance();
    logger.setLoggingLevel(TraceLevel);
    QDir().mkdir(logDir);
    QString logPath = QString("%1/%2").arg(logDir).arg("log");
    DestinationPtr fileDst(DestinationFactory::MakeFileDestination(
    logPath, EnableLogRotation, MaxSizeBytes(2*1024*1024), MaxOldLogCount(50)));
    logger.addDestination(fileDst);
    DestinationPtr consoleDst(DestinationFactory::MakeDebugOutputDestination());
    logger.addDestination(consoleDst);
}

void FMPInitTask::LoadTheme(const QString &theme)
{
    QString rccPath = QString("%1/skin/%2.rcc").arg(g_appDir).arg(theme);
    qDebug()<<rccPath;
    if(!QFile(rccPath).exists())
    {
        return;
    }
    QResource::registerResource(rccPath);

    QFile qssFile(QString(":/%1.qss").arg(theme));
    if(!qssFile.open(QFile::ReadOnly))
    {
        return;
    }
    mainForm->setStyleSheet(qssFile.readAll());
    //floatForm->setStyleSheet(qssFile.readAll());
    qssFile.close();
}

void FMPInitTask::Init()
{
    LoadLogger();
    LoadTheme(APP_THEME);

    QLOG_INFO() << QString("-------- fmTakeaway[%1] Start --------").arg(APP_VERSION);

    // 将控制器移到工作线程
    FlowControl::GetInstance().moveToThread(&workThread);
    //workThread.start();
    QObject::connect(mainForm, &MainForm::showFloatForm, floatForm, &FloatForm::onShow);
    QObject::connect(mainForm, &MainForm::startRemind, floatForm, &FloatForm::onStartRemind);
    QObject::connect(&FlowControl::GetInstance(), &FlowControl::startRemind, floatForm, &FloatForm::onStartRemind);
    QObject::connect(mainForm, &MainForm::stopRemind, floatForm, &FloatForm::onStopRemind);
    QObject::connect(floatForm, &FloatForm::showMainForm, mainForm, &MainForm::show);
    mainForm->MyShow();
    // 将门店信息获取控制器移到工作线程
    SInfoControl::GetInstance().SetListenPort(ConfigManger::GetInstance().GetTcpServerPort());
    SInfoControl::GetInstance().moveToThread(&sInfoThread);
    QObject::connect(&sInfoThread, &QThread::started, &SInfoControl::GetInstance(), &SInfoControl::run);
    QObject::connect(&SInfoControl::GetInstance(), &SInfoControl::getNewStoreInfo, &FlowControl::GetInstance(), &FlowControl::onGetNewStoreInfo);
    sInfoThread.start();
}

FMPInitTask::~FMPInitTask()
{
    workThread.quit();
    sInfoThread.quit();
    delete mainForm;
    mainForm=0;
    delete floatForm;
    floatForm=0;
}

