#ifndef FMPTAKEOUTEVENTHANDLER_H
#define FMPTAKEOUTEVENTHANDLER_H

#include <QObject>
#include <service/event/ctkEventConstants.h>
#include <service/event/ctkEventHandler.h>


class FMPTakeout;

class FMPTakeoutEventHandler : public ctkEventHandler
{
public:
    explicit       FMPTakeoutEventHandler(const QString &topic, FMPTakeout *Takeout) : _Takeout(Takeout), _topic(topic) {}
protected:
    FMPTakeout*        _Takeout;
    const QString       _topic;
};


class FMPStartEventHandler : public QObject, public FMPTakeoutEventHandler
{
    Q_OBJECT
    Q_INTERFACES(ctkEventHandler)
public:
    explicit            FMPStartEventHandler(ctkPluginContext *ctx, FMPTakeout *Takeout);
    void                handleEvent(const ctkEvent &event);

private:
    ctkPluginContext*   _ctx;
};



#endif // FMPTAKEOUTEVENTHANDLER_H
