﻿#include "fmp_te_handlers.h"
#include "fmp_takeout.h"

FMPStartEventHandler::FMPStartEventHandler(ctkPluginContext *ctx, FMPTakeout *Takeout)
    : FMPTakeoutEventHandler(FMP_TOPICS_SERVICES FMPE_SERVICE_ACK_START "/"+ QString::number(ctx->getPlugin()->getPluginId()),
       Takeout),
      _ctx(ctx)
{
    FMPProps props;
    props[ctkEventConstants::EVENT_TOPIC] = _topic;
    _ctx->registerService<ctkEventHandler>(this, props);
}

void FMPStartEventHandler::handleEvent(const ctkEvent &event)
{
    if (_Takeout) {
        if (event.getProperty(FMP_PROPKEY_AGREED).toBool()) {
//            _epay->UpgradeOldPlugins(event.getProperty(FMP_PROPKEY_PID_LIST).toList());
            _Takeout->TriggerInit();
        }
        else {
            //FMP_WARN_CTX(_ctx) << "Refused start request" << event.getTopic();
        }

    }
    else {
      //  FMP_DEBUG_CTX(_ctx) << "No handler instance for event" << event.getTopic();
    }
}
