/*=============================================================================

  Library: CTK

  Copyright (c) German Cancer Research Center,
    Division of Medical and Biological Informatics

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

=============================================================================*/


#include "fmp_takeout_plugin_p.h"

#include "fmp_takeout.h"

#include <QtPlugin>
#include <QStringList>
#include <QDebug>

FMPTakeoutPlugin::FMPTakeoutPlugin()
  : _takeout_service(0)
{
}

void FMPTakeoutPlugin::start(ctkPluginContext* context)
{
  _takeout_service = new FMPTakeout(context);
  context->registerService<FMPTakeoutInterface>( _takeout_service);
}

void FMPTakeoutPlugin::stop(ctkPluginContext* context)
{
  Q_UNUSED(context)
  if (_takeout_service)
  {
    delete _takeout_service;
    _takeout_service = 0;
  }

  int a = 0;
}

#if (QT_VERSION < QT_VERSION_CHECK(5,0,0))
Q_EXPORT_PLUGIN2(fmp_takeout, FMPTakeoutPlugin)
#endif
