﻿#include "fmp_takeout_p.h"
#include <fmp_settings_i.h>
#include <QDateTime>
#include <ctkPluginContext.h>
#include <ctkServiceReference.h>

#include "fmp_home_i.h"
#include "fmp_printer_i.h"
#include "fmp_te_handlers.h"
#include "DTools/configManger.h"


FMPTakeoutPrivate::FMPTakeoutPrivate(FMPTakeout *parent)
: q_ptr(parent),
  inittask(nullptr)
{

}

int FMPTakeoutPrivate::Init()
{
    Q_Q(FMPTakeout);
    if(!q)
    {
        return 0;
    }
    else
    {
        if(0 == q->_inited)
            {
                _Home = q->GetService<FMPHomeInterface>(q->_ctx);
                InitTakeout();
                q->_inited = true;
                return FMP_SUCCESS;
            }
        else{
            //emit sgnGetFromHome();
            return 1;
        }
    }

}

FMPTakeoutPrivate::~FMPTakeoutPrivate()
{
    Uninit();
}
int FMPTakeoutPrivate::Uninit()
{
    Q_Q(FMPTakeout);
    //emit sgnStopTime();
    if(_Home!= nullptr)
    {
        _Home = 0;
    }
    if(_settings!= nullptr)
    {
        _settings = 0;
    }
    delete inittask;
    inittask=0;
    q->_inited = false;
    return FMP_SUCCESS;
}

void FMPTakeoutPrivate::InitTakeout()
{
    ConfigManger::GetInstance().InitConfigManger(_settings);
    inittask=new FMPInitTask();
    inittask->Init();
}
