#ifndef FMPTAKEOUTINTERFACE_H
#define FMPTAKEOUTINTERFACE_H

#include <fmp_plugin_i.h>

#include "fmp_takeout_def.h"

/**
 * 业务插件接口，必须继承自 FMPluginInterface
 * @brief The FMPTakeoutInterface class
 */
class FMPTakeoutInterface : public QObject, public FMPluginInterface
{
    Q_OBJECT
    Q_INTERFACES(FMPBaseInterface)
    Q_INTERFACES(FMPluginInterface)
public:
    explicit            FMPTakeoutInterface(ctkPluginContext *ctx) : FMPluginInterface(ctx)
    {
        connect(this, &FMPTakeoutInterface::TriggerInit, this, &FMPTakeoutInterface::OnTriggerInit, Qt::UniqueConnection);
        connect(this, &FMPTakeoutInterface::TriggerUninit, this, &FMPTakeoutInterface::OnTriggerUninit, Qt::UniqueConnection);
    }

signals:
    void                TriggerInit();
    void                TriggerUninit();

protected slots:
    void                OnTriggerInit() { FMPluginInterface::OnTriggerInit(); }
    void                OnTriggerUninit() { FMPluginInterface::OnTriggerUninit(); }
};

Q_DECLARE_INTERFACE(FMPTakeoutInterface, "com.fmp.takeout")


#endif // FMPTAKEOUTINTERFACE_H
