
TEMPLATE = lib

QT += core gui network sql multimedia

greaterThan(QT_MAJOR_VERSION, 4): QT += widgets

include("./QsLog/QsLog.pri")

DESTDIR = ./bin
MOC_DIR = ./tmp
OBJECTS_DIR = ./tmp
UI_HEADERS_DIR = ./tmp
RCC_DIR = ./tmp
SOURCES +=fmp_takeout.cpp \
    fmp_takeout_p.cpp \
    fmp_takeout_plugin.cpp \
    fmp_te_handlers.cpp \
    fmpinittask.cpp \
    alertForm.cpp \
    detailForm.cpp \
    floatForm.cpp \
    mainForm.cpp \
    padForm.cpp \
    pickForm.cpp \
    RejectForm.cpp \
    settingForm.cpp \
    Control/flowControl.cpp \
    Control/sinfoControl.cpp \
    DTools/clickedLineEdit.cpp \
    DTools/configManger.cpp \
    DTools/dataManger.cpp \
    DTools/headframe.cpp \
    DTools/orderstatus.cpp \
    DTools/util.cpp \
    Model/baseObject.cpp \
    Model/cashierObject.cpp \
    Model/deliverObject.cpp \
    Model/orderObject.cpp \
    Model/productObject.cpp \
    Network/billSocket.cpp \
    QsLog/QsLog.cpp \
    QsLog/QsLogDest.cpp \
    QsLog/QsLogDestConsole.cpp \
    QsLog/QsLogDestFile.cpp \
    QsLog/QsLogDestFunctor.cpp \
    DTools/fmPlugin.cpp


HEADERS +=fmp_takeout_i.h \
    fmp_takeout.h \
    fmp_takeout_p.h \
    fmp_takeout_plugin_p.h \
    fmp_te_handlers.h\
    fmp_takeout_def.h \
    fmpinittask.h \
    alertForm.h \
    detailForm.h \
    floatForm.h \
    mainForm.h \
    padForm.h \
    pickForm.h \
    preDefine.h \
    RejectForm.h \
    settingForm.h \
    res/resource.h \
    Control/flowControl.h \
    Control/sinfoControl.h \
    DTools/clickedLineEdit.h \
    DTools/configManger.h \
    DTools/dataManger.h \
    DTools/headframe.h \
    DTools/orderstatus.h \
    DTools/util.h \
    Model/baseObject.h \
    Model/cashierObject.h \
    Model/deliverObject.h \
    Model/orderObject.h \
    Model/productObject.h \
    Network/billSocket.h \
    QsLog/QsLog.h \
    QsLog/QsLogDest.h \
    QsLog/QsLogDestConsole.h \
    QsLog/QsLogDestFile.h \
    QsLog/QsLogDestFunctor.h \
    QsLog/QsLogDisableForThisFile.h \
    QsLog/QsLogLevel.h \
    DTools/fmPlugin.h



FORMS    +=  \
    alertForm.ui \
    detailForm.ui \
    floatForm.ui \
    mainForm.ui \
    padForm.ui \
    pickForm.ui \
    RejectForm.ui \
    settingForm.ui

unix {
    target.path = /usr/lib
    INSTALLS += target
}

#Target name
VER = $$system($$PWD/../fmprc.bat $$TARGET)
ORIGIN_TARGET = $$TARGET
TARGET = $${TARGET}_$${VER}

#Header path
INCLUDEPATH += $$PWD/../include/ctk \
            += $$PWD/../include/interface \

#Library path
LIBS += -L$$PWD/../lib
LIBS += -lWinspool
CONFIG(debug, debug|release) {
    #Linking library
        LIBS += -lCTKCored -lCTKPluginFrameworkd
    #Destination path
    DESTDIR = $$PWD/../debug/plugins
} else {
    LIBS += -lCTKCore -lCTKPluginFramework
    DESTDIR = $$PWD/../release/plugins
}

#
RESOURCES += \
    res/$${ORIGIN_TARGET}.qrc \
    res/image.qrc
win32 {
    RC_FILE += res/$${ORIGIN_TARGET}.rc
    system($$PWD/../fmprc.bat $$PWD/version.h $$ORIGIN_TARGET)
}
else {
    system($$PWD/../fmprc.sh $$PWD/version.h $$ORIGIN_TARGET)
}

