#include "fmp_takeout_p.h"
#include "fmp_te_handlers.h"
FMPTakeout::FMPTakeout(ctkPluginContext *context)
    : FMPTakeoutInterface(context),
      _inited(false),
      d_ptr(new FMPTakeoutPrivate(this))
{
    FMPStartEventHandler *se = new FMPStartEventHandler(_ctx, this);
}

FMPTakeout::~FMPTakeout()
{
    StopService();
    if (d_ptr) {
        delete d_ptr;
        d_ptr = nullptr;
    }
}

void FMPTakeout::InitService()
{
    d_func()->Init();
}

void FMPTakeout::UninitService()
{
    if (_inited) {
        d_func()->Uninit();
    }
}


