﻿#include "detailForm.h"
#include "ui_detailForm.h"
#include "DTools/util.h"
#include "preDefine.h"
#include "DTools/configManger.h"
#include "Control/flowControl.h"
#include "DTools/orderstatus.h"
#include "DTools/fmPlugin.h"
#include "QsLog.h"

DetailForm::DetailForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::DetailForm)
{
    ui->setupUi(this);
    connect(this, &DetailForm::processOrder, &FlowControl::GetInstance(), &FlowControl::onProcessOrder);
    connect(this, &DetailForm::processRejectOrder, &FlowControl::GetInstance(), &FlowControl::onProcessRejectOrder);

    _Init();
}

DetailForm::~DetailForm()
{
    delete ui;
}

void DetailForm::InitData(OrderObject *orderObject)
{
    m_orderObject = orderObject;
    // 恢复界面
    ui->detailTable0->clearContents();
    ui->detailTable0->setRowCount(0);
    ui->detailBtn2->show();
    ui->detailBtn3->show();
    ui->detailBtn0->hide();
    ui->detailBtn1->hide();

    // 初始化界面
    ui->detailLab0->setText(QString("[%1][%2][%3]").arg(orderObject->channelName,
                                                        orderObject->status_desc,
                                                        orderObject->order_id));
    ui->detailLab1->setText(QString("[%1]%2").arg(orderObject->pay_type,
                                                  orderObject->remark));
    ui->detailLab2->setText(QString("[姓名]%1 [电话]%2").arg(orderObject->customer,
                                                            orderObject->phone));
    ui->detailLab3->setText(orderObject->address);
    ui->detailLab4->setText(QString("[配送方式]%1 [配送费]%2").arg(orderObject->delivery_party,
                                                                 Penny2Dollar(orderObject->send_fee)));
    ui->detailLab5->setText(orderObject->delivery_time==0? "立即送出" : QDateTime::fromTime_t(orderObject->delivery_time).toString("MM/dd hh:mm"));
    ui->detailLab6->setText(orderObject->courier_name.isEmpty() ? "暂未指定" : QString("[姓名]%1 [电话]%2")
                                                                            .arg(orderObject->courier_name, orderObject->courier_phone));
    ui->detailLab7->setText(!orderObject->pay_type.compare("在线支付") ? "0" : Penny2Dollar(orderObject->shop_fee));
    ui->detailLab8->setText(orderObject->has_invoiced? QString("发票抬头:%1").arg(orderObject->invoice_title) : "不需要发票");

    for(int i=0; i<orderObject->proList.count(); i++)
    {
        ui->detailTable0->insertRow(i);
        ui->detailTable0->setItem(i, 0, new QTableWidgetItem(orderObject->proList.at(i)->name));  // 商品名
        ui->detailTable0->item(i, 0)->setTextAlignment(Qt::AlignCenter);
        ui->detailTable0->setItem(i, 1, new QTableWidgetItem(Penny2Dollar(orderObject->proList.at(i)->price)));  // 价格
        ui->detailTable0->item(i, 1)->setTextAlignment(Qt::AlignCenter);
        ui->detailTable0->setItem(i, 2, new QTableWidgetItem(QString::number(orderObject->proList.at(i)->productAmount)));  // 数量
        ui->detailTable0->item(i, 2)->setTextAlignment(Qt::AlignCenter);
    }

    QString records;
    foreach(QString record, orderObject->records)
    {
        records.append(record+"\r\n");
    }
    ui->detailLabRecord->setText(records);
    ui->detailBtn2->setText(GetOperNameByStatus(orderObject->status, true));
    ui->detailBtn2->setProperty("operation", GetOperByStatus(orderObject->status, true));
    ui->detailBtn2->setProperty("orderId", orderObject->order_id);
    if(orderObject->status != 1 && orderObject->status != 20&& orderObject->status != 2&& orderObject->status != 4)
    {
        ui->detailBtn2->hide();
    }

    ui->detailBtn3->setText(GetOperNameByStatus(orderObject->status));
    ui->detailBtn3->setProperty("operation", GetOperByStatus(orderObject->status));
    ui->detailBtn3->setProperty("orderId", orderObject->order_id);

    if(!GetOperByStatus(orderObject->status).compare("NULL"))
    {
        ui->detailBtn3->hide();
    }
    if(orderObject->status==3||orderObject->status==100)
    {
        if(!Orderstatus::getInstance().isrefund(m_orderObject->order_id))
        {
            ui->detailBtn1->show();
        }
        ui->detailBtn0->hide();
    }
    else{
        ui->detailBtn1->hide();
        if(!Orderstatus::getInstance().isentry(m_orderObject->order_id))
        {
            ui->detailBtn0->show();
        }
        else
        {
            ui->detailBtn0->hide();
        }
    }
    m_rejectForm = new RejectForm(this);
}

void DetailForm::_Init()
{
    setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint);
    setGeometry(((QWidget*)parent())->geometry());

    int tableWidth = this->width()/2 - 65;
    ui->detailTable0->setColumnWidth(0, tableWidth*5/9);
    ui->detailTable0->setColumnWidth(1, tableWidth*2/9);
    ui->detailTable0->setColumnWidth(2, tableWidth*2/9);
    ui->detailTable0->horizontalHeader()->setFixedHeight(25);
    ui->detailTable0->horizontalHeader()->setSectionResizeMode(QHeaderView::Fixed);
    ui->detailBtn1->hide();
}

void DetailForm::onOperaBtnClicked()
{
    hide();
    QPushButton *pBtn = (QPushButton*)sender();
    if(pBtn->text()=="拒单")
    {
        m_rejectForm->show();
        if(m_rejectForm->exec()==QDialog::Accepted)
            {
                emit processRejectOrder( pBtn->property("orderId").toString(),m_rejectForm->GetReasonCode(),0);
            }
    }
    else if(pBtn->text()=="退单")
    {
        m_rejectForm->show();
        if(m_rejectForm->exec()==QDialog::Accepted)
            {
                emit processRejectOrder( pBtn->property("orderId").toString(),m_rejectForm->GetReasonCode(),1);
            }
    }
    else
    {
        emit processOrder(pBtn->property("operation").toString(), pBtn->property("orderId").toString(), DeliverObject());
    }
}

void DetailForm::on_detailBtn1_clicked()
{
    QString error;
    if(!FmPlugin::GetInstance().RefundOrder(m_orderObject->order_id, error))
    {
        QLOG_INFO() << QString("reRefund order failed[%1]").arg(error);
        emit showEntryResult(m_orderObject,0);
        emit showAlert(AlertForm::ERROR, QString("重新撤销销售单失败[%1]").arg(error));
    }
    else
    {
        Orderstatus::getInstance().refundupdate(m_orderObject->order_id,1);
        QLOG_INFO() << QString("[reRefund order success].");
        emit showEntryResult(m_orderObject,1);
        emit showAlert(AlertForm::SUCCESS, QString("[重新撤销销售单成功]."));
    }
}

void DetailForm::on_detailBtn0_clicked()
{
    QString error;
    if(!FmPlugin::GetInstance().DoOrderEntry(m_orderObject, error))
    {
        QLOG_INFO() << QString("reEntry order failed[%1]").arg(error);
        emit showEntryResult(m_orderObject,0);
        emit showAlert(AlertForm::ERROR, QString("重新补录销售单失败[%1]").arg(error));
    }
    else
    {
        Orderstatus::getInstance().entryupdate(m_orderObject->order_id,1);
        QLOG_INFO() << QString("[reEntry order success].");
        emit showEntryResult(m_orderObject,1);
        emit showAlert(AlertForm::SUCCESS, QString("[重新补录销售单成功]."));
    }
}
