#include "billSocket.h"

#include <QtNetwork/QNetworkReply>
#include "DTools/configManger.h"
#include "preDefine.h"
#include <QEventLoop>
#include <QTimer>

BillSocket::BillSocket(QObject *parent)
    : QObject(parent)
{
    m_networkRequest.setUrl(ConfigManger::GetInstance().GetServerUrl());
    m_networkRequest.setRawHeader("Content-Type","text/json");
}

BillSocket::~BillSocket()
{

}

bool BillSocket::Request(const QJsonObject &requestJson, QJsonObject &recvJson, QString &error)
{
    if(QNetworkAccessManager::Accessible != m_networkManger.networkAccessible())
    {
        m_networkManger.setNetworkAccessible(QNetworkAccessManager::Accessible);
    }

    QByteArray sendArray = QJsonDocument(requestJson).toJson(QJsonDocument::Compact);
    QEventLoop eventLoop;
    QNetworkReply *reply = m_networkManger.post(m_networkRequest , sendArray);
    connect(&m_networkManger, SIGNAL(networkAccessibleChanged(QNetworkAccessManager::NetworkAccessibility)), &eventLoop, SLOT(quit()));
    connect(reply, SIGNAL(finished()), &eventLoop, SLOT(quit()));
    connect(reply, SIGNAL(error(QNetworkReply::NetworkError)), &eventLoop, SLOT(quit()));
    // 加用定时器防止网络出现异常长时间不返回导致的阻塞
    QTimer::singleShot(VALUE_NETTIMEOUT, &eventLoop, &QEventLoop::quit);
    eventLoop.exec();

   if(reply->error() != QNetworkReply::NoError)
   {
       error = reply->errorString();
       return false;
   }

   QByteArray recvArray = reply->readAll();
   if(recvArray.size() == 0)
   {
       error = "nothing recved";
       return false;
   }
   recvJson = QJsonDocument::fromJson(recvArray).object();
   qDebug() << recvJson;
   reply->deleteLater();

   return true;
}
