#ifndef ORDEROBJECT_H
#define ORDEROBJECT_H

#include "productObject.h"

class OrderObject : public BaseObject
{
    Q_OBJECT
public:
    OrderObject(QObject *parent=0)
        :BaseObject(parent){}

    /* 功能:从Json对象初获取数据
     * 参数:[1]JSon对象
     * 返回:NULL
     * */
    void FromJson(const QJsonObject& json);

public:
    Q_PROPERTY (QString channel READ getChannel WRITE setChannel)
    Q_PROPERTY (QString channelName READ getchannelName WRITE setchannelName)
    Q_PROPERTY (QString phone READ getphone WRITE setphone)
    Q_PROPERTY (QString address READ getaddress WRITE setaddress)
    Q_PROPERTY (QString customer READ getcustomer WRITE setcustomer)
    Q_PROPERTY (QString delivery_party READ getdelivery_party WRITE setdelivery_party)
    Q_PROPERTY (QString order_id READ getOrder_id WRITE setOrder_id)
    Q_PROPERTY (QString posorder_id READ getposorder_id WRITE setposorder_id)
    Q_PROPERTY (QString coupon READ getCoupon WRITE setCoupon)
    Q_PROPERTY (QString remark READ getRemark WRITE setRemark)
    Q_PROPERTY (QString timestamp READ getTimestamp WRITE setTimestamp)
    Q_PROPERTY (QString pay_type READ getpay_type WRITE setpay_type)
    Q_PROPERTY (QString printcfg READ getprintcfg WRITE setprintcfg)
    Q_PROPERTY (int delivery_type READ getDelivery_type WRITE setDelivery_type)
    Q_PROPERTY (int paid_fee READ getpaid_fee WRITE setpaid_fee)
    Q_PROPERTY (int rest_fee READ getrest_fee WRITE setrest_fee)
    Q_PROPERTY (int user_fee READ getuser_fee WRITE setuser_fee)
    Q_PROPERTY (int shop_fee READ getshop_fee WRITE setshop_fee)
    Q_PROPERTY (int status READ getstatus WRITE setstatus)
    Q_PROPERTY (int create_time READ getCreate_time WRITE setCreate_time)
    Q_PROPERTY (int expire_time READ getExpire_time WRITE setExpire_time)
    Q_PROPERTY (int total_fee READ gettotal_fee WRITE settotal_fee)
    Q_PROPERTY (int discount_fee READ getdiscount_fee WRITE setdiscount_fee)
    Q_PROPERTY (int send_fee READ getsend_fee WRITE setsend_fee)
    Q_PROPERTY (int total_amount READ gettotal_Amount WRITE settotal_Amount)
    Q_PROPERTY (int channelNum READ getchannelNum WRITE setchannelNum)
    Q_PROPERTY (int order_index READ getorder_index WRITE setorder_index)
    Q_PROPERTY (bool has_invoiced READ gethas_invoiced WRITE sethas_invoiced)
    Q_PROPERTY (QString invoice_title READ getinvoice_title WRITE setinvoice_title)
    Q_PROPERTY (QString courier_name READ getcourier_name WRITE setcourier_name)
    Q_PROPERTY (QString courier_phone READ getcourier_phone WRITE setcourier_phone)
    Q_PROPERTY (QString status_desc READ getstatus_desc WRITE setstatus_desc)
    Q_PROPERTY (int delivery_time READ getdelivery_time WRITE setdelivery_time)
    Q_PROPERTY (int delivery_status READ getdelivery_status WRITE setdelivery_status)
    Q_PROPERTY (QString fm_id READ getfm_id WRITE setfm_id)
    Q_PROPERTY (QStringList records READ getrecords WRITE setrecords)
    Q_PROPERTY (int service_fee READ getservice_fee WRITE setservice_fee)
    Q_PROPERTY (int dis_platform_fee READ getdis_platform_fee WRITE setdis_platform_fee)
    Q_PROPERTY (int dis_shop_fee READ getdis_shop_fee WRITE setdis_shop_fee)
    Q_PROPERTY (int package_fee READ getpackage_fee WRITE setpackage_fee)
    Q_PROPERTY (int product_fee READ getproduct_fee WRITE setproduct_fee)


    int service_fee;         //平台佣金
    int dis_platform_fee;    //平台承担的优惠金额
    int dis_shop_fee;        //商户承担的优惠金额
    int package_fee;         //打包费

    QString address;         //地址
    QString channel;         //渠道
    QString channelName;     //渠道名称
    QString customer;        //用户姓名
    QString coupon;          //码
    QString courier_name;    //配送员信息
    QString courier_phone;   //配送员电话
    int channelNum;          //渠道当天序号
    int create_time;         //订单时间
    int delivery_type;       //自配送/平台配送
    QString delivery_party;  //派送方式
    int delivery_time;   //期望送达时间
    int delivery_status;     //配送状态
    int discount_fee;        //商品优惠
    int expire_time;         //订单倒计时
    QString fm_id;           //非码订单编号
    bool has_invoiced;       //是否需要发票
    QString invoice_title;   //发票抬头
    QString order_id;        //订单号
    int order_index;         //渠道当天序号
    QString pay_type;        //支付方式
    QString phone;           //电话
    QString posorder_id;     //pos订单号
    QString printcfg;        //打印联
    QList<ProductObject *> proList; //商品明细
    int paid_fee;            //已付金额
    QString remark;          //备注
    int rest_fee;            //未付
    QString status_desc;     //订单状态描述
    int status;              //订单状态
    int shop_fee;            //应收金额(商家和骑士看到的)
    int send_fee;            //运费金额
    QString timestamp;       //时间戳
    int total_fee;           //商品金额 
    int total_amount;        //总件数
    int user_fee;            //应付金额
    int product_fee;        //商品金额(含打包费)
    QStringList records;         //订单操作记录



protected:
    int getservice_fee() const ;
    void setservice_fee(const int& v);
    int getdis_platform_fee() const ;
    void setdis_platform_fee(const int& v);
    int getdis_shop_fee() const ;
    void setdis_shop_fee(const int& v);
    int getpackage_fee() const ;
    void setpackage_fee(const int& v);
    int getDelivery_type()const;
    void setDelivery_type(const int& v);
    int getstatus() const ;
    void setstatus(const int& v);
    QString getChannel() const ;
    void setChannel(const QString& v);
    QString getchannelName() const ;
    void setchannelName(const QString& v);
    QString getphone() const ;
    void setphone(const QString& v);
    QString getaddress() const ;
    void setaddress(const QString& v);
    QString getcustomer() const ;
    void setcustomer(const QString& v);
    QString getdelivery_party() const ;
    void setdelivery_party(const QString& v);
    QString getOrder_id() const ;
    void setOrder_id(const QString& v);
    QString getposorder_id() const ;
    void setposorder_id(const QString& v);
    int getpaid_fee() const ;
    void setpaid_fee(const int& v);
    int getshop_fee() const ;
    void setshop_fee(const int& v);
    int getproduct_fee() const ;
    void setproduct_fee(const int& v);
    int getrest_fee() const ;
    void setrest_fee(const int& v);
    int getuser_fee() const ;
    void setuser_fee(const int& v);
    QString getCoupon() const ;
    void setCoupon(const QString& v);
    QString getRemark() const ;
    void setRemark(const QString& v);
    int getCreate_time() const ;
    void setCreate_time(const int& v);
    int getExpire_time() const ;
    void setExpire_time(const int& v);
    QString getTimestamp() const ;
    void setTimestamp(const QString& v);
    QString getpay_type() const ;
    void setpay_type(const QString& v);
    QString getprintcfg() const ;
    void setprintcfg(const QString& v);
    int gettotal_fee() const ;
    void settotal_fee(const int& v);
    int getdiscount_fee() const ;
    void setdiscount_fee(const int& v);
    int getsend_fee() const ;
    void setsend_fee(const int& v);
    int gettotal_Amount() const ;
    void settotal_Amount(const int& v);
    int getchannelNum() const ;
    void setchannelNum(const int& v);
    int getorder_index() const ;
    void setorder_index(const int& v);
    bool gethas_invoiced() const;
    void sethas_invoiced(const bool& v);
    QString getinvoice_title() const;
    void setinvoice_title(const QString& v);
    QString getcourier_name() const;
    void setcourier_name(const QString& v);
    QString getcourier_phone() const;
    void setcourier_phone(const QString& v);
    QString getstatus_desc() const;
    void setstatus_desc(const QString& v);
    int getdelivery_time() const;
    void setdelivery_time(const int& v);
    QString getfm_id() const;
    void setfm_id(const QString& v);
    int getdelivery_status() const ;
    void setdelivery_status(const int& v);
    QStringList getrecords() const;
    void setrecords(const QStringList& v);
};

#endif // ORDEROBJECT_H
