#include "orderstatus.h"
#include "QsLog.h"
#include <QCoreApplication>

Orderstatus::Orderstatus()
{
    QString dbpath=QCoreApplication::applicationDirPath()+QString("/orderstatus.db");
    //db.addDatabase("QSQLITE");
    QSqlDatabase db=QSqlDatabase::addDatabase("QSQLITE");
    //db.setDatabaseName("orderstatus.db");
    db.setDatabaseName(dbpath);
    if(!db.open())
    {
        QString error=db.lastError().text();
        QLOG_ERROR()<<QString("Qsqlite database open filed,%1").arg(error);
    }
    else{
        QLOG_INFO()<<QString("Qsqlite database open successed");
    }
    QSqlQuery query;
    int isTableExist;
    query.exec(QString("select count(*) from sqlite_master where type='table' and name='%1'").arg("status"));
    while(query.next())
    {
        isTableExist = query.value(0).toInt();
    }
    if(!isTableExist){
        QLOG_INFO() << "table status does not exist";
        query.exec(QString("create table status (orderId  varchar(20) primary key, isentry int(1),isrefund int(1))"));
    } else{
        QLOG_INFO() << "table status exists";
    }
    //qDebug()<<query.lastError().text()<<"create table error";
}

Orderstatus &Orderstatus::getInstance()
{
    static Orderstatus order;
    return order;
}

bool Orderstatus::statusinsert(const QString &orderId, const int &entrystatus,const int &refundstatus)
{
    QSqlQuery query;
    query.prepare(QString("insert into status values('%1',%2,%3)").arg(orderId).arg(QString::number(entrystatus)).arg(QString::number(refundstatus)));
    if(!query.exec())
    {
        QLOG_ERROR()<<query.lastError().text()<<QString::number(query.lastError().type())<<"statusinsert";
        return false;
    }
    else{
        QLOG_INFO()<<QString("insert orderId %1 into status success").arg(orderId);
        return true;
    }
}

bool Orderstatus::entryupdate(const QString &orderId, const int &entrystatus)
{
    QSqlQuery query;
    query.prepare(QString("update status set isentry=%1 where orderId='%2'").arg(QString::number(entrystatus)).arg(orderId));
    if(!query.exec())
    {
        QLOG_ERROR()<<query.lastError().text()<<"entryupdate";
        return false;
    }
    else{
        QLOG_INFO()<<QString("update orderId %1 entrystatus success").arg(orderId);
        return true;
    }
}

bool Orderstatus::isentry(const QString &orderId)
{
    QSqlQuery query;
    query.prepare(QString("select isentry from status where orderId='%1'").arg(orderId));
    if(!query.exec())
    {
        QLOG_ERROR()<<query.lastError().text()<<"isentry";
        return false;
    }
    while(query.next())
    {
        return query.value(0).toBool();
    }
}

bool Orderstatus::refundupdate(const QString &orderId, const int &refundstatus)
{
    QSqlQuery query;
    query.prepare(QString("update status set isrefund=%1 where orderId='%2'").arg(QString::number(refundstatus)).arg(orderId));
    if(!query.exec())
    {
        QLOG_ERROR()<<query.lastError().text()<<"refundupdate";
        return false;
    }
    else{
        QLOG_INFO()<<QString("update orderId %1 status success").arg(orderId);
        return true;
    }
}

bool Orderstatus::isrefund(const QString &orderId)
{
    QSqlQuery query;
    query.prepare(QString("select isrefund from status where orderId='%1'").arg(orderId));
    if(!query.exec())
    {
        QLOG_ERROR()<<query.lastError().text()<<"isrefund";
        return false;
    }
    while(query.next())
    {
        return query.value(0).toBool();
    }
}
bool Orderstatus::isorderexit(const QString &orderId)
{
    QSqlQuery query;
    query.prepare(QString("select orderId from status where orderId='%1'").arg(orderId));
    if(!query.exec())
    {
        QLOG_ERROR()<<query.lastError().text()<<"isorderexit";
        return false;
    }
    if(query.first())
    {
        return true;
    }
    else{
        return false;
    }
}

