#ifndef HEADFRAME_H
#define HEADFRAME_H
#include <QMouseEvent>
#include <QFrame>


class HeadFrame : public QFrame
{
public:
    HeadFrame(QWidget *parent)
        :QFrame(parent){}
protected:
    void mouseMoveEvent(QMouseEvent * event);
    void mousePressEvent(QMouseEvent * event);
    void mouseReleaseEvent(QMouseEvent * event);

private:
    // 记录左键按下去后是否移动过
    bool m_bMouseMove;
    // 记录左键是否按下去
    bool m_bMousePress;
    // 拖动前鼠标坐标
    QPoint m_lastMousePos;
    // 此次拖动一共移动的距离
    QPoint m_absMove;
};

#endif // HEADFRAME_H
