﻿#ifndef CONFIGMANGER_H
#define CONFIGMANGER_H

#include <QSettings>
#include <QUrl>
#include <QPoint>
class FMPSettingsInterface;

class ConfigManger
{

public:
    void InitConfigManger(FMPSettingsInterface *settings);
    void GetStoreInfo(QString& storeId, QString& posNo, QString& cashierId, QString &password);
    static ConfigManger& GetInstance();
    /* 功能:读取服务器地址
     * 参数:NULL
     * 返回:服务器地址
     * */
    QUrl GetServerUrl();
//    /* 功能:读取打印机名称
//     * 参数:NULL
//     * 返回:服务器地址
//     * */
//    QString GetPrinterName();
//    /* 功能:设置打印机名称
//     * 参数:打印机名称
//     * 返回:NULL
//     * */
//    void SetPrinterName(const QString& printer);
    /* 功能:读取悬浮窗坐标
     * 参数:NULL
     * 返回:服务器地址
     * */
    QPoint GetFloatInitPostion();
    /* 功能:设置悬浮窗坐标
     * 参数:NULL
     * 返回:服务器地址
     * */
    void setFloatInitPostion(const QPoint& postion);
    /* 功能:获取悬浮窗闪烁间隔时长
     * 参数:NULL
     * 返回:间隔时长
     * */
    int GetBlinkInterval();
    /* 功能:获取播放声音间隔时长
     * 参数:NULL
     * 返回:间隔时长
     * */
    int GetSoundInterval();
    /* 功能:获取是否存在[重新补单]
     * 参数:NULL
     * 返回:true存在false不存在
     * */
    bool GetIsExistReEntryOrder();
    /* 功能:获取TCP监听端口
     * 参数:NULL
     * 返回:端口号
     * */
    int GetTcpServerPort();
    /* 功能:获取销售单写入地址
     * 参数:NULL
     * 返回:销售单地址
     * */
    QString GetDbServerIp();
    /* 功能:获取销售单写入端口
     * 参数:NULL
     * 返回:销售单端口
     * */
    int GetDbServerPort();
    int GetAutoconfirm();

private:
    ConfigManger(){}
    ConfigManger(ConfigManger const&);
    ConfigManger& operator=(ConfigManger const&);

private:
    // 程序配置和用户配置
    FMPSettingsInterface *_settings;
};

#endif // CONFIGMANGER_H
