﻿#include "configManger.h"

#include <QApplication>
#include "preDefine.h"
#include <fmp_settings_i.h>

void ConfigManger::InitConfigManger(FMPSettingsInterface *settings)
{
    _settings=settings;
}

void ConfigManger::GetStoreInfo(QString &storeId, QString &posNo,QString &cashierId,QString &password)
{
    storeId=_settings->GetValue(INI_STOREID).toString();
    posNo=_settings->GetValue(INI_POSNO).toString();
    cashierId="001";
    //password=_settings->GetValue(INI_PASSWORD).toString();
    password=SERVER_PASSWORD;
}

ConfigManger &ConfigManger::GetInstance()
{
    static ConfigManger cm;
    return cm;
}

QUrl ConfigManger::GetServerUrl()
{
    return _settings->GetValue(INI_SERVER).toUrl();
}

QPoint ConfigManger::GetFloatInitPostion()
{
    return _settings->GetValue(INI_FLOATPOSTION, QPoint(20, 20)).toPoint();
}

void ConfigManger::setFloatInitPostion(const QPoint &postion)
{
    _settings->SetValue(INI_FLOATPOSTION, postion);
}

int ConfigManger::GetBlinkInterval()
{
    return _settings->GetValue(INI_BLINKINTERVAL).toFloat()*1000;
}

int ConfigManger::GetSoundInterval()
{
    return _settings->GetValue(INI_SOUNDINTERVAL).toFloat()*1000;
}

int ConfigManger::GetTcpServerPort()
{
    return _settings->GetValue(INI_TCPPORT, 34953).toInt();
}

QString ConfigManger::GetDbServerIp()
{
    return _settings->GetValue(INI_DBSERVERIP).toString();
}

int ConfigManger::GetDbServerPort()
{
    return _settings->GetValue(INI_DBSERVERPORT).toInt();
}

int ConfigManger::GetAutoconfirm()
{
    return _settings->GetValue(INI_AUTOCONFIRM).toInt();
}



