﻿#ifndef FMP_SETS_DLG_H
#define FMP_SETS_DLG_H

#include <fmp_window.hpp>
#include <QWidget>
#include <QFileDialog>
#include <QSettings>
#include <QPushButton>

namespace Ui {
class FMPSettingsWindow;
}

class FMPSettingsInterface;
class ctkPluginContext;

class FMPSettingsWindow : public FMPWindow
{
    Q_OBJECT

public:
    explicit FMPSettingsWindow(FMPSettingsInterface *fmp_sets, QWidget *parent = 0);
    ~FMPSettingsWindow();
    void setsettings(QSettings *set);
signals:
    bool settingChanged(const QString&,QVariant);

private:
    Ui::FMPSettingsWindow *ui;
    QSettings *m_set;
    QWidget *getwidget(QString widgetname);
    FMPSettingsInterface    *_fmp_sets;

private slots:
    void onSettingeditingFinished();
    void onSettingcheck_clicked(bool checked);
    void onsettingcombo_currentIndex(QString content);
    void onsettingcombo_currentIndex(int content);
    //void on_btn_pluginpath_clicked();
    void on_btn_logpath_clicked();
    void on_btn_showwidget_clicked();
    void OnTestPrintClicked();
};

#endif // FMP_SETS_DLG_H
