﻿#include <QLineEdit>
#include <QCheckBox>
#include <QComboBox>
#include <qDebug>
#include <QScrollBar>
#include <QPropertyAnimation>

#include <fmp_home_i.h>
#include <fmp_logger_i.h>
#include <fmp_epay_i.h>
#include <fmp_takeout_i.h>
#include <fmp_printer_i.h>
#include <fmp_settings_i.h>



#include "window.h"
#include "ui_window.h"
#include "../fmp_home/version.h"


FMPSettingsWindow::FMPSettingsWindow(FMPSettingsInterface *fmp_sets, QWidget *parent) :
    FMPWindow(parent),
    ui(new Ui::FMPSettingsWindow),
    _fmp_sets(fmp_sets)
{
    ui->setupUi(this);
    connect(ui->btn_close, SIGNAL(clicked(bool)), SLOT(close()));
    connect(ui->btn_testprint, SIGNAL(clicked(bool)), SLOT(OnTestPrintClicked()));
}

FMPSettingsWindow::~FMPSettingsWindow()
{
    delete ui;
}

void FMPSettingsWindow::setsettings(QSettings* set)
{
    m_set=set;
    ui->edt_posid->setText(m_set->value(FMP_INIKEY_LOGINPOSID).toString());
//    ui->edt_pwd->setText(m_set->value(FMP_INIKEY_LOGINPWD).toString());
//    ui->edt_pwd_2->setText(m_set->value(FMP_INIKEY_LOGINPWD).toString());
    ui->edt_partnerid->setText(m_set->value(FMP_INIKEY_LOGINPARTNERID).toString());
//    ui->edt_account->setText(m_set->value(FMP_INIKEY_HOMEACCOUNT).toString());
//    ui->edt_pluginpath->setText(m_set->value(FMP_INIKEY_PLUGINPATH).toString());
    ui->edt_logpath->setText(m_set->value(FMP_INIKEY_LOGPATH).toString());
//    ui->edt_loginsvr->setText(m_set->value(FMP_INIKEY_LOGINSERVER).toString());
    ui->edt_storeid->setText(m_set->value(FMP_INIKEY_LOGINSTOREID).toString());
    ui->edt_logsize->setText(m_set->value(FMP_INIKEY_LOGSIZE).toString());
//    ui->switch_animation->setChecked(m_set->value(FMP_INIKEY_ANIMATION).toBool());
//    ui->switch_autologin->setChecked(m_set->value(FMP_INIKEY_HOMEAUTOLOGIN).toBool());
    ui->select_loglevel->setCurrentIndex(m_set->value(FMP_INIKEY_LOGLEVEL).toInt());
    ui->select_printer->setCurrentText(m_set->value(FMP_INIKEY_PRINTERNAME).toString());
    ui->select_printersize->setCurrentText(m_set->value(FMP_INIKEY_PRINTERSIZE).toString());
    ui->check_autoconfirm->setChecked(m_set->value(FMP_INIKEY_TAKEOUTAUTO).toBool());
//    ui->check_customer->setCheckable(m_set->value(FMP_INIKEY_TAKEOUTCUSTOMER).toBool());
//    ui->check_deliver->setCheckable(m_set->value(FMP_INIKEY_TAKEOUTDELIVER).toBool());
//    ui->check_store->setCheckable(m_set->value(FMP_INIKEY_TAKEOUTSTORE).toBool());
    ui->edt_orderurl->setText(m_set->value(FMP_INIKEY_TAKEOUTSERVER).toString());
//    ui->edt_entryport->setText(m_set->value(FMP_INIKEY_TAKEOUTENTRYPORT).toString());
//    ui->edt_entryurl->setText(m_set->value(FMP_INIKEY_TAKEOUTENTRYSERVER).toString());
//    ui->edt_storeid_2->setText(m_set->value(FMP_INIKEY_TAKEOUTSTOREID).toString());
    ui->edt_cashierid->setText(m_set->value(FMP_INIKEY_LOGINCASHIER).toString());
    ui->edt_epayurl->setText(m_set->value(FMP_INIKEY_EPAYURL).toString());
    ui->edt_epaytimeout->setText(m_set->value(FMP_INIKEY_EPAYTIMEOUT).toString());

    ui->label_version->setText(RES_STR_PRODUCT_VER);

    /*--------------------------------------------------------------*/
    ui->edt_posid->home(false);
//    ui->edt_pwd->home(false);
//    ui->edt_pwd_2->home(false);
    ui->edt_partnerid->home(false);
//    ui->edt_account->home(false);
//    ui->edt_pluginpath->home(false);
    ui->edt_logpath->home(false);
//    ui->edt_loginsvr->home(false);
    ui->edt_storeid->home(false);
    ui->edt_logsize->home(false);
    ui->edt_orderurl->home(false);
//    ui->edt_entryport->home(false);
//    ui->edt_entryurl->home(false);
//    ui->edt_storeid_2->home(false);
    ui->edt_cashierid->home(false);
}

QWidget *FMPSettingsWindow::getwidget(QString widgetname)
{
    if(!widgetname.compare("general"))
    {
        return ui->general;
    }
    if(!widgetname.compare("pay"))
    {
        return ui->pay_group;
    }
    if(!widgetname.compare("takeout"))
    {
        return ui->takeout_group;
    }
}


void FMPSettingsWindow::onSettingeditingFinished()
{

    QLineEdit *edt=(QLineEdit*)sender();
    edt->home(false);
    qDebug()<<edt->property("key").toString()<<edt->text();
    emit settingChanged(edt->property("key").toString(),edt->text());
}

void FMPSettingsWindow::onsettingcombo_currentIndex(QString content)
{
    QComboBox *combox=(QComboBox*)sender();
    emit settingChanged(combox->property("key").toString(),content);
}

void FMPSettingsWindow::onsettingcombo_currentIndex(int content)
{
    QComboBox *combox=(QComboBox*)sender();
    emit settingChanged(combox->property("key").toString(),content);
}

void FMPSettingsWindow::onSettingcheck_clicked(bool checked)
{
    QCheckBox* check=(QCheckBox*)sender();
    emit settingChanged(check->property("key").toString(),(int)checked);
}

//void FMPSettingsWindow::on_btn_pluginpath_clicked()
//{
//    QString pluginpath = QFileDialog::getExistingDirectory(this, "路径选择",NULL, QFileDialog::ShowDirsOnly);
//    if(!logpath.isEmpty())
//    {
//       ui->edt_pluginpath->setText(pluginpath);
//    }
//
//}

void FMPSettingsWindow::on_btn_logpath_clicked()
{
    QString logpath = QFileDialog::getExistingDirectory(this, "路径选择",NULL, NULL);
    if(!logpath.isEmpty())
    {
        ui->edt_logpath->setText(logpath);
        ui->edt_logpath->editingFinished();
    }
}

void FMPSettingsWindow::on_btn_showwidget_clicked()
{
    QPushButton* btn=(QPushButton*)sender();
    QWidget *presentwidget=getwidget(btn->property("widget").toString());

    QScrollBar * scroll = ui->scrollArea->verticalScrollBar();
    QPropertyAnimation *animation = new QPropertyAnimation(scroll, "value");
    animation->setStartValue(scroll->value());
    animation->setEndValue(scroll->maximum() * 1.0 / ui->scrollAreaWidgetContents->height() * presentwidget->y());
    animation->start(QPropertyAnimation::DeleteWhenStopped);
}

void FMPSettingsWindow::OnTestPrintClicked()
{
    if (_fmp_sets) {
        FMPPrinterInterface *printer = FMP::GetService<FMPPrinterInterface>();
        if (printer) {
            printer->GetPrintName();
//            printer->DoPrint(QString::fromLocal8Bit("这是一个测试页看到此页说明打印正常!\r\n\r\n\r\n"));
        }
    }
}
