#ifndef FMP_SETTINGS_H
#define FMP_SETTINGS_H

#include "fmp_settings_i.h"
#include "ui./window.h"

class FMPSettingsPrivate;

/**
 * @brief The FMPSettings class
 */
class FMPSettings : public QObject, public FMPSettingsInterface
{
    Q_OBJECT
    Q_INTERFACES(FMPBaseInterface)
    Q_INTERFACES(FMPSettingsInterface)
    Q_DECLARE_PRIVATE(FMPSettings)

public:
    explicit            FMPSettings(const FMPContext ctx);
    virtual             ~FMPSettings();

protected:
    //! BaseInterface
    void                InitService();
    void                UninitService();
    int                 PostEvent(const QString &topic, const FMPProps &pps = FMPProps());
    const FMPContext    GetContext() const { return context; }

    //! SettingsInterface
public:
    QVariant            GetValue(const QString &k, const QVariant &default_val);
    bool                SetValue(const QString&k, const QVariant &v);

private:
    FMPSettingsPrivate *d_ptr;
    const FMPContext    context;
};


class QSettings;
/**
 * @brief The FMPSettingsPrivate class
 */
class FMPSettingsPrivate:public QObject
{
    Q_OBJECT
    Q_DECLARE_PUBLIC(FMPSettings)
public:
    explicit            FMPSettingsPrivate();

    int                 Init();
    int                 Uninit();
    QVariant            GetValue(const QString &k, const QVariant &default_val);
    bool                SetValue(const QString&k, const QVariant &v);

public:
    FMPSettings        *q_ptr;
    QSettings          *_sets;
private:
    FMPSettingsWindow *settingwindow;
};

#endif // FMP_SETTINGS_H
