﻿#include "fmp_settings.h"
#include <QSettings>
#include <fmp_logger_i.h>
#include <ctkServiceReference.h>
#include "ui/window.h"
#include <QDebug>

#ifdef Q_OS_WIN
#undef StartService
#endif

/**
 * @brief The FMPSettings class
 */
FMPSettings::FMPSettings(const FMPContext ctx)
    : context(ctx),
      d_ptr(new FMPSettingsPrivate())
{
    StartService();
}

FMPSettings::~FMPSettings()
{
    StopService();

    if (d_ptr) {
        delete d_ptr;
        d_ptr = nullptr;
    }
}

void FMPSettings::InitService()
{
    d_func()->Init();
}

void FMPSettings::UninitService()
{
    d_func()->Uninit();
}

int FMPSettings::PostEvent(const QString &topic, const FMPProps &pps)
{
    Q_UNUSED(topic);
    Q_UNUSED(pps);
    return FMP_SUCCESS;
}


QVariant FMPSettings::GetValue(const QString &k, const QVariant &default_val)
{
    Q_D(FMPSettings);

    return d->GetValue(k, default_val);
}

bool FMPSettings::SetValue(const QString &k, const QVariant &v)
{
    Q_D(FMPSettings);

    return d->SetValue(k, v);
}

/**
 ***************************************************************
 */
FMPSettingsPrivate::FMPSettingsPrivate()
    : _sets(0)
{ 

}

int FMPSettingsPrivate::Init()
{
    if (!_sets) {
        //_sets = new QSettings(FMP::GetProperties()[FMP_PROPKEY_CFG].toString(), QSettings::IniFormat);
        _sets = new QSettings(qApp->applicationDirPath() + "/" + FMP_PROPKEY_CFG, QSettings::IniFormat);
    }
    else {
        FMPSettingsWindow * set_dlg = new FMPSettingsWindow(q_ptr);
        set_dlg->setsettings(_sets);
        set_dlg->show();
        connect(set_dlg,&FMPSettingsWindow::settingChanged,this,&FMPSettingsPrivate::SetValue);
    }

    return FMP_SUCCESS;
}

int FMPSettingsPrivate::Uninit()
{
    if (_sets) {
        delete _sets;
        _sets = 0;
    }

    return FMP_SUCCESS;
}

QVariant FMPSettingsPrivate::GetValue(const QString &k, const QVariant &default_val)
{
    return _sets->value(k, default_val);
}

bool FMPSettingsPrivate::SetValue(const QString &k, const QVariant &v)
{
    _sets->setValue(k, v);
    return (_sets->value(k) == v);
}
