﻿#include "fmp_epayview_wait.h"
#include "fmp_epayview_dialog.h"
#include "ui_fmp_epayview_wait.h"




FMPPayWait::FMPPayWait(QWidget *parent) : QDialog(parent), ui(new Ui::FMPPayWait)
{
    ui->setupUi(this);

    setAttribute(Qt::WA_TranslucentBackground);
    ui->widget->setWindowOpacity(1);
    setGeometry(parent->geometry());
    this->move(parent->pos());
    setWindowFlags(Qt::FramelessWindowHint| Qt::Tool );

    connect(ui->btn_confirm, &QPushButton::clicked, this, &FMPPayWait::accept);

    qRegisterMetaType<FMPPayWait::Type>("FMPPayWait::Type");

    //setStyleSheet("QWidget#mainWdg{background:rgba(110,110,110,0.5)}");
}

FMPPayWait::~FMPPayWait()
{
    delete ui;
}

void FMPPayWait::SetContent(FMPPayWait::Type type, const QString &msg)
{
    switch (type) {

    case FMPPayWait::SUCCESS:
        ui->btn_confirm->setVisible(true);
        ui->label_logo->setStyleSheet("#label_logo {background: url(:/img/loading.png) center no-repeat;}");
        break;
    case FMPPayWait::ERRORS:
        ui->btn_confirm->setVisible(true);
        ui->label_logo->setStyleSheet("#label_logo {background: url(:/img/fmclient-icon_payment_fail.png) center no-repeat;}");
        break;
    case FMPPayWait::LOADING:
        ui->label_logo->setStyleSheet("#label_logo {background: url(:/img/loading.png) center no-repeat;}");
        ui->btn_confirm->setVisible(false);
        break;
    default:
        ui->btn_confirm->setVisible(true);
        ui->label_logo->setStyleSheet("#label_logo {background: url(:/img/loading.png) center no-repeat;}");
        break;
    }

    ui->label_msg->setText(msg);
}
