﻿#include "fmp_epayview_dialog.h"
#include "ui_fmp_epayview_dialog.h"
#include "fmp_epay_def.h"
#include "fmp_epay_p.h"
#include "fmp_epay_checkmodel.h"
#include "fmp_epay_plugin_p.h"
#include "fmp_forceclose_dialog.h"
#include "fmp_redeem_i.h"
#include "fmp_home_i.h"
#include "fmp_detaildialog.h"
#include "fmp_database.h"

#include <QDebug>
#include <fmp_settings_i.h>
#include <fmp_logger_i.h>
#include <QSqlTableModel>
#include <QStyledItemDelegate>
#include <QMouseEvent>
#ifdef WIN32
#include <Windows.h>
#endif
#include <QDesktopWidget>
#include <QStandardItemModel>
#include <QPropertyAnimation>
#include <QPushButton>
#include <QVBoxLayout>
#include <QSettings>
#include <QSqlRecord>
#include <QTableWidget>
#include <QSqlQuery>

FMPPayDialog::FMPPayDialog(FMPePayPrivate *control, QVariantHash basicinfo, QWidget *parent) :
    _control(control),
    QDialog(parent),
    ui(new Ui::FMPPayDialog)
{

    ui->setupUi(this);
    //this->setWindowIconText(QString::fromLocal8Bit("非码支付"));
    this->setWindowTitle(QString::fromLocal8Bit("非码支付"));

    _b_mouse_pressed = false;

    _needanimation = basicinfo[FMP_EPAY_ANIMATION].toBool();

    ui->label_date->setText(QString::fromLocal8Bit("当前营业日 : ") + basicinfo[FMP_EPAY_BUSINESSDATE].toString());
    ui->label_storeid->setText(QString::fromLocal8Bit("门店号:") + basicinfo[FMP_EPAY_STOREID].toString());
    ui->label_posno->setText(QString::fromLocal8Bit("POS编号:") + basicinfo[FMP_EPAY_STATIONID].toString());
    ui->label_optid->setText(QString::fromLocal8Bit("操作员:") + basicinfo[FMP_EPAY_OPERATORID].toString());

    _wait = NULL;
    _success_flag = false;
    _is_amt = false;

    this->setWindowFlags( windowFlags() | Qt::WindowStaysOnTopHint | Qt::FramelessWindowHint);
    this->setWindowFlags(Qt::FramelessWindowHint);
    setAttribute(Qt::WA_QuitOnClose, false);

    connect(ui->btn_num0, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num00, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num1, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num2, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num3, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num4, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num5, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num6, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num7, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num8, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num9, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_numdot, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);

    connect(ui->btn_num0_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num00_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num1_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num2_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num3_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num4_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num5_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num6_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num7_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num8_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num9_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_numdot_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);

    connect(ui->btn_confirm01, &QPushButton::clicked, this, &FMPPayDialog::onBtnConfirmClicked);
    connect(ui->btn_confirm01_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnConfirmClicked);
    connect(ui->lineedit_code, &FMPFocusLineEdit::returnPressed, this, &FMPPayDialog::onBtnConfirmClicked);



    connect(ui->lineedit_num_refund, &FMPFocusLineEdit::focusIn, this, &FMPPayDialog::onLineeditCodeGetFocus);
    connect(ui->lineedit_code_refund, &FMPFocusLineEdit::focusIn, this, &FMPPayDialog::onLineeditCodeGetFocus);
    connect(ui->lineedit_code_refund, &FMPFocusLineEdit::returnPressed, this, &FMPPayDialog::onBtnConfirmClicked);

    connect(ui->lineedit_num, &FMPFocusLineEdit::focusIn, this, &FMPPayDialog::onLineeditCodeGetFocus);
    connect(ui->lineedit_code, &FMPFocusLineEdit::focusIn, this, &FMPPayDialog::onLineeditCodeGetFocus);

    connect(ui->btn_pay, &QPushButton::clicked, this, &FMPPayDialog::onWidgetChange);
    connect(ui->btn_check, &QPushButton::clicked, this, &FMPPayDialog::onWidgetChange);
    connect(ui->btn_refund, &QPushButton::clicked, this, &FMPPayDialog::onWidgetChange);
    //支付订单处理
    connect(ui->btn_waitPay, &QPushButton::clicked, this, &FMPPayDialog::onWidgetChange);
    connect(ui->btn_errorOrder, &QPushButton::clicked, this, &FMPPayDialog::onWidgetChange);
    connect(ui->btn_success, &QPushButton::clicked, this, &FMPPayDialog::onWidgetChange);
    connect(ui->btn_done, &QPushButton::clicked, this, &FMPPayDialog::onWidgetChange);
    connect(ui->btn_dailyBill, &QPushButton::clicked, this, &FMPPayDialog::onWidgetChange);

    connect(_control, &FMPePayPrivate::error, this, &FMPPayDialog::showErrorMsg);
    connect(_control, &FMPePayPrivate::finished, this, &FMPPayDialog::showSuccessMsg);


    ui->lineedit_num->setFocus();
    _current_LineEdit = ui->lineedit_num;


    ui->tableView->setEditTriggers(QAbstractItemView::NoEditTriggers);
    ui->tableView->setItemDelegate(new FMPPayItemDelegate);
    connect(ui->tableView, SIGNAL(clicked(QModelIndex)), SLOT(onSelectionChanged(QModelIndex)));
    connect(ui->tableView_waitPay, SIGNAL(clicked(QModelIndex)), SLOT(onWaitPaySelectionChanged(QModelIndex)));

    QSqlTableModel *model = _control->model();

    model->setHeaderData(0, Qt::Horizontal, QString::fromLocal8Bit("非码交易号"));
    model->setHeaderData(4, Qt::Horizontal, QString::fromLocal8Bit("交易渠道"));
    model->setHeaderData(6, Qt::Horizontal, QString::fromLocal8Bit("金额(元)"));
    model->setHeaderData(11, Qt::Horizontal, QString::fromLocal8Bit("营业日期"));
    model->setHeaderData(12, Qt::Horizontal, QString::fromLocal8Bit("退款"));

    ui->tableView->setModel(model);

    ui->tableView->hideColumn(1);
    ui->tableView->hideColumn(2);
    ui->tableView->hideColumn(3);
    ui->tableView->hideColumn(5);
    ui->tableView->hideColumn(7);
    ui->tableView->hideColumn(8);
    ui->tableView->hideColumn(9);
    ui->tableView->hideColumn(10);
    ui->tableView->hideColumn(13);

    ui->tableView->setSelectionMode(QTableView::SingleSelection);
    ui->tableView->setSelectionBehavior(QTableView::SelectRows);

    ui->tableView->verticalHeader()->setVisible(false);
    QHeaderView *header = ui->tableView->horizontalHeader();
    ui->tableView->setColumnWidth(0, 200);
    //ui->tableView->setColumnWidth(2, 220);
    ui->tableView->setColumnWidth(4, 160);
    ui->tableView->setColumnWidth(6, 100);
    ui->tableView->setColumnWidth(11, 100);

    header->setVisible(true);
    header->setStretchLastSection(true);

    setTableHeader();
    QRegExp rx("^(([1-9]+)|([0-9]+.[0-9]{1,2}))$");
    QRegExpValidator *pReg = new QRegExpValidator(rx, this);
    ui->lineedit_num->setValidator(pReg);

    QRegExp rxs("^[A-Za-z0-9]+$");
    QRegExpValidator *pRegs = new QRegExpValidator(rxs, this);
    ui->lineedit_code->setValidator(pRegs);

    _curt_btn = ui->btn_pay;

    ui->wdg_done_main->move(0, ui->wdg_done_main->height());
    ui->wdg_errorPay_main->move(0, ui->wdg_errorPay_main->height());
    ui->wdg_hasPay_main->move(0, ui->wdg_hasPay_main->height());
    ui->wdg_query_main->move(0, ui->wdg_query_main->height());
    ui->wdg_refund_main->move(0, ui->wdg_refund_main->height());
    ui->wdg_success_main->move(0, ui->wdg_success_main->height());
    ui->wdg_dailyBill_main->move(0, ui->wdg_dailyBill_main->height());

    if (basicinfo["fm_cmd"].toInt() == 10031) {
        ui->btn_pay->click();
        ui->lineedit_num->setText(QString::number(basicinfo["amount"].toDouble() / 100));
        ui->lineedit_num->setEnabled(false);
        ui->lineedit_code->setFocus();
    }
    else if (basicinfo["fm_cmd"].toInt() == 10041) {
        ui->btn_refund->click();
        ui->lineedit_code_refund->setFocus();
        ui->lineedit_num_refund->setText(QString::number(basicinfo["amount"].toDouble() / 100));
        ui->lineedit_num_refund->setEnabled(false);
    }

    if (basicinfo["fm_cmd"].toInt() == 10031 || basicinfo["fm_cmd"].toInt() == 10041) {
//        ui->btn_check->setEnabled(false);
//        ui->btn_refund->setEnabled(false);
//        ui->btn_pay->setEnabled(false);
    }
    QPushButton* redeem = new QPushButton(QString::fromLocal8Bit("卡券支付"), this);
    redeem->setStyleSheet("width:220px");
    connect(redeem, &QPushButton::clicked, this, &FMPPayDialog::redeem);
    QVBoxLayout* layout = qobject_cast<QVBoxLayout*>(ui->frame->layout());
    layout->insertWidget(4, redeem);
    _products_info = basicinfo["products"].toJsonArray();
    ui->tableView_hasPay->setToolTip(QString::fromLocal8Bit("双击查看支付详情"));
    connect(ui->tableView_hasPay, &QTableView::doubleClicked, this, &FMPPayDialog::ShowPayDetail);

    setShowFunc();
}

void FMPPayDialog::setTableHeader()
{
    //edit by cuiguanghui
    QSqlTableModel *model_done = _control->model();
    model_done->setHeaderData(3, Qt::Horizontal, QString::fromLocal8Bit("POS交易号"));
    model_done->setHeaderData(4, Qt::Horizontal, QString::fromLocal8Bit("交易渠道"));
    model_done->setHeaderData(6, Qt::Horizontal, QString::fromLocal8Bit("金额(元)"));
    model_done->setHeaderData(14, Qt::Horizontal, QString::fromLocal8Bit("状态"));
    model_done->setHeaderData(16, Qt::Horizontal, QString::fromLocal8Bit("交易时间"));

    QVector<QTableView*> vecTables;
    vecTables.push_back(ui->tableView_Done);
    vecTables.push_back(ui->tableView_errorPay);
    vecTables.push_back(ui->tableView_hasPay);
    vecTables.push_back(ui->tableView_waitPay);
    for(int i=0;i<vecTables.size();i++){
        vecTables[i]->setModel(model_done);

        vecTables[i]->hideColumn(0);
        vecTables[i]->hideColumn(1);
        vecTables[i]->hideColumn(2);
        vecTables[i]->hideColumn(5);
        vecTables[i]->hideColumn(7);
        vecTables[i]->hideColumn(8);
        vecTables[i]->hideColumn(9);
        vecTables[i]->hideColumn(10);
        vecTables[i]->hideColumn(11);
        vecTables[i]->hideColumn(12);
        vecTables[i]->hideColumn(13);
        vecTables[i]->hideColumn(15);

        vecTables[i]->setSelectionMode(QTableView::SingleSelection);
        vecTables[i]->setSelectionBehavior(QTableView::SelectRows);
        vecTables[i]->setEditTriggers(QTableView::NoEditTriggers);

        vecTables[i]->verticalHeader()->setVisible(false);
        QHeaderView *header_done = vecTables[i]->horizontalHeader();
        vecTables[i]->setColumnWidth(3, 160);
        vecTables[i]->setColumnWidth(4, 150);
        vecTables[i]->setColumnWidth(6, 70);
        vecTables[i]->setColumnWidth(14, 90);
        vecTables[i]->setColumnWidth(16, 160);

        header_done->setVisible(true);
        header_done->setStretchLastSection(true);
    }
    ui->btn_waitPay->setChecked(true);
}

void FMPPayDialog::show()
{
    _api_force_close=false;
#ifdef WIN32
    showNormal();
    HWND hForeWnd = ::GetForegroundWindow();
    DWORD dwForeID = ::GetWindowThreadProcessId(hForeWnd,NULL);
    DWORD dwCurID = ::GetCurrentThreadId();
    ::AttachThreadInput(dwCurID,dwForeID,TRUE);

    ::SetForegroundWindow((HWND)effectiveWinId());

    ::SetWindowPos( (HWND)effectiveWinId(), HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_SHOWWINDOW);

    showNormal();
    ::SetForegroundWindow((HWND)effectiveWinId());

    ::AttachThreadInput(dwCurID,dwForeID,FALSE);
    QDesktopWidget w;
    QRect rc = w.availableGeometry();
    setGeometry((rc.width() - width()) / 2, (rc.height() - height()) / 2, width(), height());
#else
#endif

    return QDialog::show();
}

void FMPPayDialog::onWidgetChange()
{
    QPushButton *tmpcur = _curt_btn;

    if(_is_amt)
    {
        return ;
    }

    if(_success_flag)
    {
        _success_flag = false;
        _curt_btn = (QPushButton *)sender();
        QWidget *nextwdg = findChild<QWidget *>(_curt_btn->property("pageName").toString());
        PlayAnimation(ui->wdg_success_main, nextwdg, LeftToRight);

        if(_curt_btn->property("index").toInt() == 0)
            setPayView();

        if(_curt_btn->property("index").toInt() == 1)
            setRefundView();

        if(_curt_btn->property("index").toInt() == 2)
            setCheckView();

        return ;
    }

    if(_curt_btn == sender())
    {
        return ;
    }

    _curt_btn = (QPushButton *)sender();

    if(_curt_btn->property("index").toInt() == 0)
        setPayView();

    if(_curt_btn->property("index").toInt() == 1)
        setRefundView();

    if(_curt_btn->property("index").toInt() == 2)
        setCheckView();

    if(_curt_btn->property("index").toInt() == 3)
        setWaitPayView();

    if(_curt_btn->property("index").toInt() == 4)
        setErrorOrderView();

    if(_curt_btn->property("index").toInt() == 5)
        setSuccessView();

    if(_curt_btn->property("index").toInt() == 6)
        setDoneView();

    if(_curt_btn->property("index").toInt() == 7)
        setDailyBillView();

    Movemode move = BtmToTop;

    QWidget *nextwdg = findChild<QWidget *>(_curt_btn->property("pageName").toString());
    QWidget *currwdg = findChild<QWidget *>(tmpcur->property("pageName").toString());


    if(_curt_btn->property("index").toInt() < tmpcur->property("index").toInt())
        move = TopToBtm;

    PlayAnimation(currwdg, nextwdg, move);

    ui->lineedit_num->clear();
    ui->lineedit_code->clear();
    ui->lineedit_num_refund->clear();
    ui->lineedit_code_refund->clear();

}

void FMPPayDialog::showErrorMsg(QString errormsg)
{
    ui->lineedit_code->clear();

    if(errormsg == "")
        errormsg = QString("");

    if(_wait == NULL)
    {
        _wait = new FMPPayWait(this);
        _wait->setModal(true);
    }
    if(_control->_is_api){
        _wait->SetContent(FMPPayWait::ERRORS, errormsg);

        if(_wait->isHidden())
            _wait->show();
//        if(_wait)
//            _wait->hide();

//        FMPPayFailedDialog  *_pay_failed=new FMPPayFailedDialog(this);
//        _pay_failed->setModal(true);
//        _pay_failed->show();
//        _pay_failed->SetContent(errormsg,ui->lineedit_num->text());
    }
	else{
	    _wait->SetContent(FMPPayWait::ERRORS, errormsg);

	    if(_wait->isHidden())
	        _wait->show();
	}

}

void FMPPayDialog::showSuccessMsg(QJsonObject json)
{
    ui->label_tip->setVisible(false);
    ui->lineedit_num->clear();
    ui->lineedit_code->clear();
    ui->lineedit_num_refund->clear();
    ui->lineedit_code_refund->clear();

    if(!_wait->isHidden())
        _wait->hide();

    if(ui->btn_pay->isChecked())
        setPaySuccessView(json);
    else
        setRefundSuccessView(json);
}
void FMPPayDialog::setBasicInfo(QVariantHash basicinfo)
{
    QString date = basicinfo[FMP_BASIC_BUSINESSDATE].toString();
    ui->label_date->setText(date);
}

FMPPayDialog::~FMPPayDialog()
{
    if(_wait != NULL)
    {
        delete _wait;
    }

    delete ui;

//    if(_control != NULL)
//    {
//        delete _control;
//        _control = NULL;
//    }

}

void FMPPayDialog::onSelectionChanged(QModelIndex idx)
{
    if (ui->tableView->currentIndex() == idx) {
        ui->pushButton_2->setEnabled(true);
    }
    else {
        ui->pushButton_2->setEnabled(false);
    }
}

void FMPPayDialog::onWaitPaySelectionChanged(QModelIndex idx)
{
    if (ui->tableView_waitPay->currentIndex() == idx) {
        ui->btn_waitPay_close->setEnabled(true);
        ui->btn_waitPay_pay->setEnabled(true);
    }
    else {
        ui->btn_waitPay_close->setEnabled(false);
        ui->btn_waitPay_pay->setEnabled(false);
    }
}

void FMPPayDialog::keyPressEvent(QKeyEvent *e)
{

}

void FMPPayDialog::mousePressEvent(QMouseEvent *event)
{
       _b_mouse_pressed = true;
       _mMovePosition = event->globalPos() - pos();
       return QDialog::mousePressEvent(event);
}

void FMPPayDialog::mouseMoveEvent(QMouseEvent *event)
{
    if (_b_mouse_pressed && (event->buttons() && Qt::LeftButton)
        && (event->globalPos()-_mMovePosition).manhattanLength() > QApplication::startDragDistance())
    {
        move(event->globalPos()-_mMovePosition);
        _mMovePosition = event->globalPos() - pos();
    }
    return QDialog::mouseMoveEvent(event);
}

void FMPPayDialog::mouseReleaseEvent(QMouseEvent *event)
{
    _b_mouse_pressed = false;
}

void FMPPayDialog::setPaySuccessView(QJsonObject json)
{
    ui->lb5->show();
    ui->tlb5->show();
    ui->lb6->show();
    ui->tlb6->show();

    ui->suc2->setText(QString::fromLocal8Bit("支付成功"));
    ui->tlb1->setText(QString::fromLocal8Bit("支 付 渠 道"));
    ui->lb1->setText(json[FMP_RPAY_PAY_RETURN_PAYID].toString());
    ui->tlb2->setText(QString::fromLocal8Bit("非码交易号"));
    ui->lb2->setText(json[FMP_EPAY_REFUND_TRANSTRACTION_FMID].toString());
    ui->tlb3->setText(QString::fromLocal8Bit("支付交易号"));
    ui->lb3->setText(json[FMP_RPAY_PAY_RETURN_TRANSID].toString());
    ui->tlb4->setText(QString::fromLocal8Bit("应 付 金 额"));
    ui->lb4->setText(QString::number(json[FMP_RPAY_PAY_RETURN_TOTAL].toDouble()/100));
    ui->tlb5->setText(QString::fromLocal8Bit("优 惠 金 额"));
    ui->lb5->setText(QString::number(json[FMP_RPAY_PAY_RETURN_MCUPON].toDouble()/100));
    ui->tlb6->setText(QString::fromLocal8Bit("实 付 金 额"));
    ui->lb6->setText(QString::number(json[FMP_RPAY_PAY_RETURN_ALIPAY].toDouble()/100));

    _success_flag = true;

    PlayAnimation(findChild<QWidget *>(_curt_btn->property("pageName").toString()), ui->wdg_success_main, RightToLeft);
}

void FMPPayDialog::setRefundSuccessView(QJsonObject json)
{
    ui->suc2->setText(QString::fromLocal8Bit("退款成功"));
    ui->tlb1->setText(QString::fromLocal8Bit("支 付 渠 道"));
    ui->lb1->setText(json[SQL_KEY_PAYID].toString());
    ui->tlb2->setText(QString::fromLocal8Bit("非码交易号"));
    ui->lb2->setText(json[SQL_KEY_FMID].toString());
    ui->tlb3->setText(QString::fromLocal8Bit("支付交易号"));
    ui->lb3->setText(json[SQL_KEY_PAYTRANSID].toString());
    ui->tlb4->setText(QString::fromLocal8Bit("退 款 金 额"));
    ui->lb4->setText(json[SQL_KEY_TOTALAMOUNT].toString());
    ui->lb5->hide();
    ui->tlb5->hide();
    ui->lb6->hide();
    ui->tlb6->hide();

    _success_flag = true;

    PlayAnimation(findChild<QWidget *>(_curt_btn->property("pageName").toString()), ui->wdg_success_main, RightToLeft);
}

void FMPPayDialog::setPayView()
{
    ui->label_tip->setVisible(true);
    ui->lineedit_num->setFocus();
    ui->btn_pay->setChecked(true);
    ui->btn_refund->setChecked(false);
    ui->btn_check->setChecked(false);
    ui->btn_done->setChecked(false);
    ui->btn_waitPay->setChecked(false);
    ui->btn_errorOrder->setChecked(false);
    ui->btn_success->setChecked(false);
    ui->btn_dailyBill->setChecked(false);
    _current_LineEdit = ui->lineedit_num;
}

void FMPPayDialog::setRefundView()
{
    ui->label_tip->setVisible(true);
    ui->btn_pay->setChecked(false);
    ui->btn_refund->setChecked(true);
    ui->btn_check->setChecked(false);
    ui->btn_done->setChecked(false);
    ui->btn_waitPay->setChecked(false);
    ui->btn_errorOrder->setChecked(false);
    ui->btn_success->setChecked(false);
    ui->btn_dailyBill->setChecked(false);
    ui->lineedit_num_refund->setFocus();
    _current_LineEdit = ui->lineedit_num_refund;
}

void FMPPayDialog::setCheckView()
{   
    ui->label_tip->setVisible(false);
    ui->pushButton_2->setEnabled(false);

    ui->btn_pay->setChecked(false);
    ui->btn_refund->setChecked(false);
    ui->btn_check->setChecked(true);
    ui->btn_done->setChecked(false);
    ui->btn_waitPay->setChecked(false);
    ui->btn_errorOrder->setChecked(false);
    ui->btn_success->setChecked(false);
    ui->btn_dailyBill->setChecked(false);

    ui->lineEdit->clear();
    _control->GetMode();
}

void FMPPayDialog::setDoneView()
{
    ui->label_tip->setVisible(false);

    ui->btn_pay->setChecked(false);
    ui->btn_refund->setChecked(false);
    ui->btn_check->setChecked(false);
    ui->btn_done->setChecked(true);
    ui->btn_waitPay->setChecked(false);
    ui->btn_errorOrder->setChecked(false);
    ui->btn_success->setChecked(false);
    ui->btn_dailyBill->setChecked(false);

    _control->GetApiReqMode(ORDER_DONE);
}

void FMPPayDialog::setSuccessView()
{
    ui->label_tip->setVisible(false);

    ui->btn_pay->setChecked(false);
    ui->btn_refund->setChecked(false);
    ui->btn_check->setChecked(false);
    ui->btn_done->setChecked(false);
    ui->btn_waitPay->setChecked(false);
    ui->btn_errorOrder->setChecked(false);
    ui->btn_success->setChecked(true);
    ui->btn_dailyBill->setChecked(false);

    _control->GetApiReqMode(ORDER_PAY_SUCCESS);
}

void FMPPayDialog::setErrorOrderView()
{
    ui->label_tip->setVisible(false);

    ui->btn_pay->setChecked(false);
    ui->btn_refund->setChecked(false);
    ui->btn_check->setChecked(false);
    ui->btn_done->setChecked(false);
    ui->btn_waitPay->setChecked(false);
    ui->btn_errorOrder->setChecked(true);
    ui->btn_success->setChecked(false);
    ui->btn_dailyBill->setChecked(false);

    _control->GetApiReqMode(ORDER_HAS_ERROR);
}

void FMPPayDialog::setWaitPayView()
{
    ui->label_tip->setVisible(false);
    ui->btn_waitPay_close->setEnabled(false);
    ui->btn_waitPay_pay->setEnabled(false);

    ui->btn_pay->setChecked(false);
    ui->btn_refund->setChecked(false);
    ui->btn_check->setChecked(false);
    ui->btn_done->setChecked(false);
    ui->btn_waitPay->setChecked(true);
    ui->btn_errorOrder->setChecked(false);
    ui->btn_success->setChecked(false);
    ui->btn_dailyBill->setChecked(false);

    _control->GetApiReqMode(ORDER_NEED_PAY);
}

void FMPPayDialog::setDailyBillView()
{
    ui->label_tip->setVisible(false);
    ui->btn_waitPay_close->setEnabled(false);
    ui->btn_waitPay_pay->setEnabled(false);

    ui->btn_pay->setChecked(false);
    ui->btn_refund->setChecked(false);
    ui->btn_check->setChecked(false);
    ui->btn_done->setChecked(false);
    ui->btn_waitPay->setChecked(false);
    ui->btn_errorOrder->setChecked(false);
    ui->btn_success->setChecked(false);
    ui->btn_dailyBill->setChecked(true);

    QVector<PayDetail> vecPay;
    _control->GetDailyBillData(vecPay);

    QStandardItemModel *modelBill = new QStandardItemModel();
    modelBill->setColumnCount(3);
    modelBill->setHeaderData(0,Qt::Horizontal,QString::fromLocal8Bit("成功收款"));
    modelBill->setHeaderData(1,Qt::Horizontal,QString::fromLocal8Bit("笔数"));
    modelBill->setHeaderData(2,Qt::Horizontal,QString::fromLocal8Bit("金额(元)"));
    ui->tableView_dailyBill->setModel(modelBill);
    ui->tableView_dailyBill->setColumnWidth(0, 200);
    ui->tableView_dailyBill->setColumnWidth(1, 200);
    ui->tableView_dailyBill->setColumnWidth(2, 200);
    ui->tableView_dailyBill->setSelectionMode(QTableView::SingleSelection);
    ui->tableView_dailyBill->setSelectionBehavior(QTableView::SelectRows);
    ui->tableView_dailyBill->setEditTriggers(QTableView::NoEditTriggers);

    QStandardItemModel *modelBillFailed = new QStandardItemModel();
    modelBillFailed->setColumnCount(3);
    modelBillFailed->setHeaderData(0,Qt::Horizontal,QString::fromLocal8Bit("支付失败"));
    modelBillFailed->setHeaderData(1,Qt::Horizontal,QString::fromLocal8Bit("笔数"));
    modelBillFailed->setHeaderData(2,Qt::Horizontal,QString::fromLocal8Bit("金额(元)"));
    ui->tableView_failedBill->setModel(modelBillFailed);
    ui->tableView_failedBill->setColumnWidth(0, 200);
    ui->tableView_failedBill->setColumnWidth(1, 200);
    ui->tableView_failedBill->setColumnWidth(2, 200);
    ui->tableView_failedBill->setSelectionMode(QTableView::SingleSelection);
    ui->tableView_failedBill->setSelectionBehavior(QTableView::SelectRows);
    ui->tableView_failedBill->setEditTriggers(QTableView::NoEditTriggers);

    for(int i=0;i<vecPay.size();i++){
        if(vecPay[i].status==1){
            modelBill->setItem(i,0,new QStandardItem(vecPay[i].name));
            modelBill->setItem(i,1,new QStandardItem(vecPay[i].num));
            modelBill->setItem(i,2,new QStandardItem(vecPay[i].total));
            modelBill->item(i,0)->setTextAlignment(Qt::AlignCenter);
            modelBill->item(i,1)->setTextAlignment(Qt::AlignCenter);
            modelBill->item(i,2)->setTextAlignment(Qt::AlignCenter);
        }
        else{
            modelBillFailed->setItem(0,0,new QStandardItem(vecPay[i].name));
            modelBillFailed->setItem(0,1,new QStandardItem(vecPay[i].num));
            modelBillFailed->setItem(0,2,new QStandardItem(vecPay[i].total));
            modelBillFailed->item(0,0)->setTextAlignment(Qt::AlignCenter);
            modelBillFailed->item(0,1)->setTextAlignment(Qt::AlignCenter);
            modelBillFailed->item(0,2)->setTextAlignment(Qt::AlignCenter);
        }

    }
}

void FMPPayDialog::onBtnNumClicked()
{
    QString num_str = qobject_cast<QPushButton*>(sender())->text();

    if((_current_LineEdit == ui->lineedit_num && CheckLineEditSum(_current_LineEdit->text().append(num_str))) ||
    (_current_LineEdit == ui->lineedit_num_refund && CheckLineEditSum(_current_LineEdit->text().append(num_str))))
    {
        _current_LineEdit->setText(_current_LineEdit->text().append(num_str));
    }

    if((_current_LineEdit == ui->lineedit_code && CheckLineEditCode(_current_LineEdit->text().append(num_str))) ||
        (_current_LineEdit == ui->lineedit_code_refund && CheckLineEditCode(_current_LineEdit->text().append(num_str)))    )
    {
        _current_LineEdit->setText(_current_LineEdit->text().append(num_str));
    }
}


bool FMPPayDialog::CheckLineEditSum(QString sum)
{

    if(sum.compare("0.00") == 0 || sum.compare("00") == 0)
        return false;

    if(sum.contains("."))
    {
        QStringList list = sum.split(".");

        if(list.size() == 2)
        {
            QString tmp = list.value(1);
            if(tmp.size() > 2)
                return  false;
        }else
            return false;
    }

    return true;
}

bool FMPPayDialog::CheckLineEditCode(QString code)
{
    int i = 0;

    while( i < code.size())
    {

        if(!((code[i] >= 'a' && code[i] <= 'z') || (code[i] >= 'A' && code[i] <= 'Z') || (code[i] >= '0' && code[i] <= '9')))
            break;
        ++i;
    }

    return (i == code.size());
}

void FMPPayDialog::PlayAnimation(QWidget *target0, QWidget *target1, Movemode movemode)
{
    if(_is_amt)
    {
        return ;
    }

    _is_amt = true;

    ui->btn_pay->setEnabled(false);
    ui->btn_refund->setEnabled(false);
    ui->btn_check->setEnabled(false);    
    ui->btn_waitPay->setEnabled(false);
    ui->btn_errorOrder->setEnabled(false);
    ui->btn_success->setEnabled(false);
    ui->btn_done->setEnabled(false);
    ui->btn_dailyBill->setEnabled(false);

    int tg0_begin_x = 0, tg0_begin_y = 0;
    int tg0_end_x = 0, tg0_end_y = 0;
    int tg1_begin_x = 0, tg1_begin_y = 0;
    int tg1_end_x  = 0, tg1_end_y = 0;

    switch (movemode) {
    case TopToBtm:

        tg0_begin_x = 0, tg0_begin_y = 0;
        tg0_end_x = 0, tg0_end_y = target0->height();
        tg1_begin_x = 0, tg1_begin_y = -target1->height();
        tg1_end_x  = 0, tg1_end_y = 0;
        break;
    case BtmToTop:
        tg0_begin_x = 0, tg0_begin_y = 0;
        tg0_end_x = 0, tg0_end_y = -target0->height();
        tg1_begin_x = 0, tg1_begin_y = target1->height();
        tg1_end_x  = 0, tg1_end_y = 0;
        break;
    case LeftToRight:
        tg0_begin_x = 0, tg0_begin_y = 0;
        tg0_end_x = target0->width(), tg0_end_y = 0;
        tg1_begin_x = -target1->width(), tg1_begin_y = 0;
        tg1_end_x  = 0, tg1_end_y = 0;
        break;
    case RightToLeft:

        tg0_begin_x = 0, tg0_begin_y = 0;
        tg0_end_x = -target0->width(), tg0_end_y = 0;
        tg1_begin_x = target1->width(), tg1_begin_y = 0;
        tg1_end_x  = 0, tg1_end_y = 0;
        break;
    default:
        tg0_begin_x = 0, tg0_begin_y = 0;
        tg0_end_x = 0, tg0_end_y = target0->height();
        tg1_begin_x = 0, tg1_begin_y = -target1->height();
        tg1_end_x  = 0, tg1_end_y = 0;
        break;
    }

    target0->move(tg0_end_x, tg0_end_y);
    target1->move(tg1_end_x, tg1_end_y);

    if(_needanimation)
    {
        QPropertyAnimation animation0, animation1;
        QEventLoop loop;

        connect(&animation0, &QPropertyAnimation::finished, &loop, &QEventLoop::quit);

        animation0.setTargetObject(target0);
        animation0.setPropertyName("pos");
        animation0.setDuration(382);
        animation0.setEasingCurve(QEasingCurve::OutBack);
        animation0.setStartValue(QPoint(tg0_begin_x, tg0_begin_y));
        animation0.setEndValue(QPoint(tg0_end_x, tg0_end_y));

        animation1.setTargetObject(target1);
        animation1.setPropertyName("pos");
        animation1.setDuration(382);
        animation1.setEasingCurve(QEasingCurve::OutBack);
        animation1.setStartValue(QPoint(tg1_begin_x, tg1_begin_y));
        animation1.setEndValue(QPoint(tg1_end_x, tg1_end_y));
        animation0.start();
        animation1.start();

        loop.exec();
    }

    _is_amt = false;
    ui->btn_pay->setEnabled(true);
    ui->btn_refund->setEnabled(true);
    ui->btn_check->setEnabled(true);
    ui->btn_waitPay->setEnabled(true);
    ui->btn_errorOrder->setEnabled(true);
    ui->btn_success->setEnabled(true);
    ui->btn_done->setEnabled(true);
    ui->btn_dailyBill->setEnabled(true);
}

//确定按钮
void FMPPayDialog::onBtnConfirmClicked()
{
    if(ui->lineedit_num->text().toDouble() <= 0.0)
    {
        _api_force_close=true;
        _control->ClosePayWindow(DIALOG_FORCE_CLOSE);
        this->close();
        _control->Uninit();
        return;
    }
    
    if(_wait == NULL)
    {
        _wait = new FMPPayWait(this);
        _wait->setModal(true);
    }

    if((ui->lineedit_num->text() == "" && ui->lineedit_num_refund->text() == "") ||
       (ui->lineedit_num->text().toDouble() < 0.01  && ui->lineedit_num_refund->text().toDouble() < 0.01)||
       (ui->lineedit_code->text() == "" && ui->lineedit_code_refund->text() == "") ||
       (ui->lineedit_code->text().size() < 15 && ui->lineedit_code_refund->text().size() < 15))
    {        
        if (!_control->_is_api) {
            if(ui->lineedit_num->isEnabled())
                ui->lineedit_num->clear();
            ui->lineedit_num_refund->clear();
        }
        ui->lineedit_code->clear();
        ui->lineedit_code_refund->clear();
        _wait->SetContent(FMPPayWait::ERRORS, QString::fromLocal8Bit("金额或条码错误\n请重新输入"));
        _wait->show();
        return;
    }

    if(ui->btn_pay->isChecked())
    {
        _wait->SetContent(FMPPayWait::LOADING, QString::fromLocal8Bit("支付中..."));
        _control->ControlPayJson(ui->lineedit_num->text(), ui->lineedit_code->text());

    }
    else
    {
        _wait->SetContent(FMPPayWait::LOADING, QString::fromLocal8Bit("退款中..."));
        QJsonObject trans;
        trans["refund_amount"] = ((int)ui->lineedit_num_refund->text().toDouble() + 0.005) * 100;
        trans["fm_id"] = ui->lineedit_code_refund->text();
        _control->ControlRefundJson(trans);
    }

    _wait->show();
}


void FMPPayDialog::on_btn_backspace_clicked()
{
    _current_LineEdit->setText(_current_LineEdit->text().left(_current_LineEdit->text().length() - 1));
}

void FMPPayDialog::on_btn_clear_clicked()
{
    if (_current_LineEdit) {
        _current_LineEdit->clear();
    }
}


void FMPPayDialog::on_btn_close_clicked()
{
    if(!_control->_is_api){
        this->close();
	    _control->Uninit();
	}
	else{
        if(!_success_flag){
		    fmp_forceClose_dialog  *_force_close=new fmp_forceClose_dialog(this);
            _force_close->setModal(true);
            _force_close->show();
		}
        else{
            this->close();
            _control->Uninit();
        }
	}
}

void FMPPayDialog::onLineeditCodeGetFocus()
{
    _current_LineEdit = (FMPFocusLineEdit *) sender();

    if (ui->lineedit_num == _current_LineEdit) {
        ui->label_tip->setText(QString::fromLocal8Bit("请输入支付金额"));
    }
    else if (ui->lineedit_code == _current_LineEdit) {
        ui->label_tip->setText(QString::fromLocal8Bit("请扫描或输入条码"));
    }
    else if (ui->lineedit_num_refund == _current_LineEdit) {
        ui->label_tip->setText(QString::fromLocal8Bit("请输入退款金额"));
    }
    else if (ui->lineedit_code_refund == _current_LineEdit) {
        ui->label_tip->setText(QString::fromLocal8Bit("请扫描或输入退款码"));
    }
}

void FMPPayDialog::on_btn_success_confirm_clicked()
{
    if(_is_amt)
    {
        return ;
    }

//    if(_curt_btn->property("index").toInt() == 0)
//        setPayView();


//    if(_curt_btn->property("index").toInt() == 1)
//        setRefundView();

//    if(_curt_btn->property("index").toInt() == 2)
//        setCheckView();


    setWaitPayView();
    _curt_btn=ui->btn_waitPay;

    QWidget *nextwdg = findChild<QWidget *>(_curt_btn->property("pageName").toString());
    PlayAnimation(ui->wdg_success_main, nextwdg, LeftToRight);

    if(_control->_is_api)
        on_btn_close_clicked();

    _success_flag = false;
}

void FMPPayDialog::on_btn_paycheck_clicked()
{
    _control->GetCheckMode(ui->lineEdit->text());
}

void FMPPayDialog::on_pushButton_2_clicked()
{

    if(_wait == NULL)
    {
        _wait = new FMPPayWait(this);
        _wait->setModal(true);
    }


    QSqlTableModel *model = qobject_cast<QSqlTableModel*>(ui->tableView->model());
    QModelIndex idx = ui->tableView->currentIndex();

    _wait->SetContent(FMPPayWait::LOADING, QString::fromLocal8Bit("退款中..."));
    QJsonObject trans;
    trans["refund_amount"] = (int)((model->data(idx.sibling(idx.row(), 6)).toDouble() + 0.005) * 100);
    trans["fm_id"] = model->data(idx.sibling(idx.row(),0)).toString();
    _control->ControlRefundJson(trans);

    _wait->show();
}

void FMPPayDialog::on_btn_clear_refund_clicked()
{
    if (_current_LineEdit) {
        _current_LineEdit->clear();
    }
}

void FMPPayDialog::on_btn_backspace_refund_clicked()
{
    _current_LineEdit->setText(_current_LineEdit->text().left(_current_LineEdit->text().length() - 1));
}

void FMPPayDialog::on_lineEdit_textChanged(const QString &arg1)
{
    _control->GetCheckMode(arg1);
    ui->pushButton_2->setEnabled(false);
}
void FMPPayDialog::on_cash_pay()
{
    _api_force_close=true;
    _control->ClosePayWindow(DIALOG_CASH_CLOSE);
    this->close();  
    _control->Uninit();
}
void FMPPayDialog::on_force_close()
{
    _api_force_close=true;
    _control->ClosePayWindow(DIALOG_FORCE_CLOSE);
    this->close();
    _control->Uninit();
}
void FMPPayDialog::closeEvent(QCloseEvent * event)
{
    if(_control->_is_api&&!_api_force_close)
        event->ignore();
    else
       QDialog::closeEvent(event);
}

void FMPPayDialog::on_btn_waitPay_pay_clicked()
{
    QSqlTableModel *model = qobject_cast<QSqlTableModel*>(ui->tableView_waitPay->model());
    QModelIndex idx = ui->tableView_waitPay->currentIndex();

    double ordernum = model->data(idx.sibling(idx.row(),6)).toDouble();
    _control->setPosTransId(model->data(idx.sibling(idx.row(),3)).toString());
    ui->btn_pay->click();
    ui->lineedit_num->setText(QString::number(ordernum));
    ui->lineedit_num->setEnabled(false);
    ui->lineedit_code->setFocus();
}

void FMPPayDialog::on_btn_waitPay_close_clicked()
{
    QSqlTableModel *model = qobject_cast<QSqlTableModel*>(ui->tableView_waitPay->model());
    QModelIndex idx = ui->tableView_waitPay->currentIndex();

    QString orderId = model->data(idx.sibling(idx.row(),3)).toString();

    QJsonObject queryObj;
    queryObj[FMP_EPAY_TRANSID]=orderId;
    queryObj[FMP_RPAY_PAY_RETURN_STATUSCODE]=108;
    queryObj["msg"]=QString::fromLocal8Bit("关闭订单");

    _control->updateSqlite(queryObj);
    setWaitPayView();
}

void FMPPayDialog::setShowFunc()
{
    if(_control->_is_api){
        ui->btn_pay->setVisible(true);
        ui->btn_check->setVisible(false);
        ui->btn_refund->setVisible(false);
        ui->btn_waitPay->setVisible(false);
        ui->btn_errorOrder->setVisible(false);
        ui->btn_success->setVisible(false);
        ui->btn_done->setVisible(false);
        ui->btn_dailyBill->setVisible(false);
        ui->wdg_waitPay_main->move(0, ui->wdg_waitPay_main->height());
        ui->wdg_pay_main->move(0, 0);
    }
    else{
        ui->btn_pay->setVisible(false);
        ui->btn_check->setVisible(false);
        ui->btn_refund->setVisible(false);
        ui->btn_waitPay->setVisible(true);
        ui->btn_errorOrder->setVisible(true);
        ui->btn_success->setVisible(true);
        ui->btn_done->setVisible(true);
        ui->btn_dailyBill->setVisible(true);
        ui->wdg_pay_main->move(0, ui->wdg_pay_main->height());
        ui->wdg_waitPay_main->move(0, 0);
        ui->label_tip->setVisible(false);
        //setWaitPayView();
        ui->btn_waitPay->click();
    }
}

//卡券核销
#ifdef Q_OS_WIN
//!命名冲突
#undef StartService
#endif
void FMPPayDialog::redeem()
{
    double needPay = ui->lineedit_num->text().toDouble();
    FMPRedeemInterface* redeem = FMP::GetService<FMPRedeemInterface>();
    redeem->StartService();
    QJsonObject result = redeem->Redeem(needPay, _products_info);
    FMP_DEBUG() << "redeem result: " << result;
    needPay -= result["discount"].toInt()/100.0;
    ui->lineedit_num->setText(QString::number(qMax(0.0, needPay)));
    
    if(result["statusCode"].toInt() == 100)
    {
        //记录核销详情
        QJsonObject redeemInfo;
        redeemInfo["pay_id"] = result["couponType"].toString();
        redeemInfo["code"] = result["code"];
        redeemInfo["pid"] = result["pid"];
        redeemInfo["total_amount"] = result["discount"].toInt();
        _control->WriteRedeemToSqlite(redeemInfo);
    }
}

//展示订单支付详情
void FMPPayDialog::ShowPayDetail(const QModelIndex &index)
{
    //计算动画参数
    QPoint gPos = mapToGlobal(ui->wdg_right_bg->pos());
    int x = ui->wdg_right_bg->width() >= 550 ? gPos.x() + (ui->wdg_right_bg->width() - 550)/2 : gPos.x();
    int y = gPos.y();
    int dis = ui->wdg_right_bg->height();
    
    DetailDialog detailDlg(x, y, dis, this);
    
    //微信支付详情
    QSqlRecord record = _control->model()->record(index.row());
    detailDlg.AddData(record);
    
    //卡券支付详情
    QString transId = record.value("trans_id").toString();
    FMPDataBase* database = _control->GetDB();
    QSqlQuery query;
    if(!database->find(DEFAULT_REDEEM_TABLE, query, QStringList(), QString("trans_id=%1").arg(transId)))
    {
        FMP_ERROR() << "query redeem info failed";
    }
    else
    {
        while(query.next())
        {
            QSqlRecord record = query.record();
            detailDlg.AddData(record);
        }
    }
    detailDlg.exec();
}
