﻿#ifndef FMP_EPAY_I_H
#define FMP_EPAY_I_H

#include <fmp_plugin_i.h>

#include "fmp_epay_def.h"


/**
 * 业务插件接口，必须继承自 FMPluginInterface
 * @brief The FMPePayInterface class
 */
class FMPePayInterface : public QObject, public FMPluginInterface
{
    Q_OBJECT
    Q_INTERFACES(FMPBaseInterface)
    Q_INTERFACES(FMPluginInterface)
public:
    explicit            FMPePayInterface() : FMPluginInterface()
    {
        connect(this, &FMPePayInterface::TriggerInit, this, &FMPePayInterface::OnTriggerInit);
        connect(this, &FMPePayInterface::TriggerUninit, this, &FMPePayInterface::OnTriggerUninit);
    }

    virtual void        DockPayRequest(const QByteArray &json) = 0;
    virtual QByteArray  DockPayRespond() = 0;

    virtual void        DockRefundRequest(const QByteArray &json) = 0;
    virtual QByteArray  DockRefundRespond() = 0;

signals:
    void                TriggerInit();
    void                TriggerUninit();

protected slots:
    void                OnTriggerInit() { FMPluginInterface::OnTriggerInit(); }
    void                OnTriggerUninit() { FMPluginInterface::OnTriggerUninit(); }
};

Q_DECLARE_INTERFACE(FMPePayInterface, "fmp.epay")


#endif // FMP_LOGGER_I_H
