﻿#include "fmp_detaildialog.h"
#include "ui_fmp_detaildialog.h"

DetailDialog::DetailDialog(int x, int y, int distance, QWidget *parent) :
    QDialog(parent),
    mouse_pressed(false),
    ui(new Ui::DetailDialog)
{
    ui->setupUi(this);
    setWindowFlags(windowFlags() | Qt::FramelessWindowHint);
    ui->tableWidget->setSelectionBehavior(QAbstractItemView::SelectRows);
    ui->tableWidget->setEditTriggers(QAbstractItemView::NoEditTriggers);
    connect(ui->pushButton, &QPushButton::clicked, this, &DetailDialog::accept);
    
    animation.setTargetObject(this);
    animation.setPropertyName("geometry");
    animation.setDuration(800);
    animation.setEasingCurve(QEasingCurve::OutBack);
    animation.setStartValue(QRect(x, y + distance, 550, 0));
    animation.setEndValue(QRect(x, y, 550, 400));
    animation.start();
}

DetailDialog::~DetailDialog()
{
    delete ui;
}

void DetailDialog::mousePressEvent(QMouseEvent *event)
{
       mouse_pressed = true;
       movePosition = event->globalPos() - pos();
       return QDialog::mousePressEvent(event);
}

void DetailDialog::mouseMoveEvent(QMouseEvent *event)
{
    if (mouse_pressed && (event->buttons() && Qt::LeftButton)
        && (event->globalPos()-movePosition).manhattanLength() > QApplication::startDragDistance())
    {
        move(event->globalPos()-movePosition);
        movePosition = event->globalPos() - pos();
    }
    return QDialog::mouseMoveEvent(event);
}

void DetailDialog::mouseReleaseEvent(QMouseEvent *event)
{
    mouse_pressed = false;
}

void DetailDialog::AddData(const QSqlRecord &record)
{
    int r = ui->tableWidget->rowCount();
    ui->tableWidget->insertRow(r);
    ui->tableWidget->setItem(r, 0, new QTableWidgetItem(record.value("trans_id").toString()));
    ui->tableWidget->setItem(r, 1, new QTableWidgetItem(record.value("pay_id").toString()));
    ui->tableWidget->setItem(r, 2, new QTableWidgetItem(record.value("code").toString()));
    ui->tableWidget->setItem(r, 3, new QTableWidgetItem(record.value("pid").toString()));
    ui->tableWidget->setItem(r, 4, new QTableWidgetItem(QString::number(record.value("total_amount").toInt()/100.0)));
}
