#include "cquerythread.h"

CQueryThread::CQueryThread(FMPePayPrivate *fmPay)
    : QThread(),
      _fmPay(fmPay)
    ,_iReqCount(0)
    ,_run(false)
{

}

CQueryThread::~CQueryThread()
{

}

void CQueryThread::run()
{
    while (_run) {
        QThread::sleep(5);
        trySend();
    }
}

void CQueryThread::trySend()
{
    QString errors;
    QJsonObject outjson;
    _query_request["clientReqCount"]=_iReqCount+1;

    FMP_INFO() << "QThread trySend:" << _query_request;
    _fmPay->HttpPost(outjson, _query_request ,errors);
    if(outjson[FMP_RPAY_PAY_RETURN_STATUSCODE].toInt() != 102){
        _run=false;
        //write sqlite
        outjson[FMP_EPAY_TRANSID]=_reqJson[FMP_EPAY_TRANSID];
        _fmPay->updateSqlite(outjson);
    }
}

bool CQueryThread::isRunning()
{
    return _run;
}

void CQueryThread::setReqJson(QJsonObject reqJson)
{
    _reqJson=reqJson;
    _query_request.insert("clientReqCount",++_iReqCount);
    _query_request.insert("trans_id",_reqJson[FMP_EPAY_TRANSID]);
    _query_request.insert("station_id",_reqJson[FMP_EPAY_STATIONID]);
    _query_request.insert("partnerId",_reqJson[FMP_EPAY_PARTNERID]);
    _query_request.insert("reqtype",52);
    _query_request.insert("store_id",_reqJson[FMP_EPAY_STOREID]);
    _query_request.insert("operator_id",_reqJson[FMP_EPAY_OPERATORID]);
    _query_request.insert("ver",_reqJson[FMP_EPAY_VER]);
    _query_request.insert("fmid","");
    _run=true;
}
