﻿#ifndef FMP_EPAY_P_H
#define FMP_EPAY_P_H

#include "fmp_epay.h"
#include <QObject>
#include <QFuture>
#include <QJsonObject>

class FMPPayDialog;
class FMPSettingsInterface;
class FMPLoggerInterface;
class FMPNetworkInterface;
class FMPDataBase;
class QSqlTableModel;

class FMPePayPrivate : public QObject
{
    Q_OBJECT
    Q_DECLARE_PUBLIC(FMPePay)
public:
    explicit            FMPePayPrivate(FMPePay* parent);
    ~FMPePayPrivate();

    void                Uninit();

    void                Init();

    void                ControlPayJson(QString sum, QString code);

    void                ControlRefundJson(QString sum, QString code);

    void                GetCheckMode(QString sum);

    void                GetMode();

    bool                IsByWakeup();

    void                SetWakeupFlag(bool status);
    void                ClosePayWindow(int type=1);
    void                SendToMonitor(const QByteArray &data);

    QSqlTableModel      *model() const;

private:
    void                ControlReverseJson();

    bool                GetRefundJson(const QString &sum, const QString &code, QString ebcode, QString transid);

    void                GetReverseJson();

    bool                GetPayJson(const QString &sum, const QString &code);

    bool                HttpPost(QJsonObject& outjson, QJsonObject json, QString &error, int timeout = 60);

    bool                CheckReturnJson(QByteArray data, QJsonObject &returnjson);

    void                SetBasicInfo(QVariantHash hash);

    void                clearorder();

    void                ParsePayJson(const QByteArray &json);
signals:
    void                error(QString errormsg);

    void                finished(QJsonObject json);

protected slots:
    void                witedata();
public:

    FMPePay            *q_ptr;

    FMPPayDialog       *_payDialog;

    FMPSettingsInterface *_setting;

    FMPNetworkInterface *_network;

private:
    bool                _wakeupByMonitor;
    bool                _preOrderDone;    //前一个订单是否已经处理结束
    QJsonObject         _current_json;
    QByteArray          _pay_json;

    bool                _reverse_flag;

    static unsigned int s_ClientReqCount;

    FMPDataBase *_db;

    QSqlTableModel *_model;

    QFutureWatcher<QByteArray> *_watcher;

    void HttpPost(const QString &url, const QByteArray &data, QFutureWatcher<QByteArray> *furture, int timeout = 10);

};

#endif // FMP_EPAY_P_H
