﻿#include <QDebug>
#include <QDateTime>
#include <fmp_settings_i.h>
#include <QCoreApplication>
#include <ctkServiceReference.h>
#include "fmp_epay_p.h"
#include "fmp_epay_def.h"
#include "fmp_logger_i.h"
#include "fmp_pe_handlers.h"
#include "fmp_epayview_dialog.h"
#include "fmp_network_i.h"
#include "fmp_database.h"
#include "fmp_epay_checkmodel.h"

#include <QSslCertificate>
#include <QJsonParseError>
#include <QJsonDocument>
#include <QJsonValue>
#include <QJsonObject>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QtConcurrent>
#include <QTimer>
#include <QFuture>

#include <QSqlQuery>

#include <fmp_home_i.h>

unsigned int FMPePayPrivate::s_ClientReqCount = 10000;

FMPePayPrivate::FMPePayPrivate(FMPePay *parent)
    : q_ptr(parent),
      _payDialog(nullptr),
      _setting(nullptr),
      _model(nullptr),
      _db(nullptr),
      _watcher(nullptr),
      _reverse_flag(false),
      _is_api(false),
      _api_abort(false),
      #ifdef GuestDisplay
      _amount(0),
      #endif
      auto_close_seconds(0)
{
    _watcher = new QFutureWatcher<QByteArray>();
    connect( _watcher, SIGNAL( finished() ), this, SLOT( witedata() ) );
    connect(this, &FMPePayPrivate::confirmClicked, &_api_evt, &QEventLoop::quit);
}

FMPePayPrivate::~FMPePayPrivate()
{   
    Uninit();
}

void FMPePayPrivate::Uninit()
{
    if (_is_api && _docked_response.isEmpty()) {
        QJsonParseError err;
        QByteArray json = "{\"statusCode\":106, \"msg\":\"\347\252\227\345\217\243\345\267\262\345\205\263\351\227\255\357\274\214\344\272\244\346\230\223\345\217\226\346\266\210\", \"prompt\":0}";
        QJsonDocument d = QJsonDocument::fromJson(json, &err);
        _docked_response = d.object();
        _api_abort = true;
        emit apiError();
    }
    else if (_is_api){
        _api_abort = true;
        emit apiError();
    }

    Q_Q(FMPePay);
    q->_inited = false;

    if(_watcher != nullptr){
        delete _watcher;
        _watcher = nullptr;
    }

    if(_payDialog != nullptr) {
        delete _payDialog;
        _payDialog = nullptr;
    }

    if(_model != nullptr){
        delete _model;
        _model = nullptr;
    }

    if(_db != nullptr){
        delete _db;
        _db = nullptr;
    }

    if(_api_evt.isRunning()) {
        _api_evt.quit();
    }
}

void FMPePayPrivate::Init()
{
    Q_Q(FMPePay);
    q->_inited = true;

    clearorder();

    if(_db == nullptr)
    {
        _db = new FMPDataBase(q->_databasename);

        QString sql = "create table " + q->_table + " ("
                      "fmId varchar(40) primary key, "
                      "code varchar(40), "
                      "pay_transId varchar(40), "
                      "trans_id varchar(40),"
                      "pay_id varchar(40), "
                      "pay_ebcode varchar(20), "
                      "total_amount integer, "
                      "pcoupon_amount integer, "
                      "mcoupon_amount integer, "
                      "alipay_amount integer, "
                      "invoice_amount integer, "
                      "business_date date, "
                      "isrefund boolean, "
                      "refund_date date"
                      ")";

        FMP_INFO() << " creat table sql:" << sql;

        if(_db->creat(sql))
        {
            FMP_WARN() << "creat table fmp_pay failed";
        }
    }

    if(_model == nullptr)
    {
        _model = new FMPPayCheckModel(NULL, _db->getDb());
        _model->setTable(q->_table);
        _model->setEditStrategy(QSqlTableModel::OnManualSubmit);
    }

    QVariantHash hash;

    _setting = q->GetService<FMPSettingsInterface>(q->_ctx);
    q->_url = _setting->GetString(FMP_INIKEY_EPAYURL);
    q->_partner_id = _setting->GetString(FMP_INIKEY_LOGINPARTNERID);
    q->_time_out = _setting->GetInt(FMP_INIKEY_EPAYTIMEOUT);
    q->_time_out = (q->_time_out > 60 ? q->_time_out : 60);

    auto_close_seconds=_setting->GetInt(FMP_INIKEY_EPAYAUTOCLOSE);
    auto_close_seconds=auto_close_seconds>0 ? auto_close_seconds:5;

    hash[FMP_EPAY_PARTNERID] = q->_partner_id;
    hash[FMP_EPAY_TIMEOUT] = q->_time_out;

    if (!_is_api) {
        q->_store_id = _setting->GetString(FMP_INIKEY_LOGINSTOREID);
        q->_station_id = _setting->GetString(FMP_INIKEY_LOGINPOSID);
        q->_operator_id = _setting->GetString(FMP_INIKEY_LOGINCASHIER);

        hash[FMP_EPAY_ANIMATION] = _setting->GetBool(FMP_INIKEY_ANIMATION);
        hash[FMP_EPAY_BUSINESSDATE] = q->_businessdate;
        hash[FMP_EPAY_STOREID] = q->_store_id;
        hash[FMP_EPAY_STATIONID] = q->_station_id;
        hash[FMP_EPAY_OPERATORID] = q->_operator_id;
    }
    else if (_is_api && !_origin_request.isEmpty()) {
        hash["fm_cmd"] = _origin_request["fm_cmd"].toVariant();
        hash[FMP_EPAY_STOREID] = _origin_request[FMP_EPAY_STOREID].toVariant();
        hash[FMP_EPAY_STATIONID] = _origin_request["pos_id"].toVariant();
        hash[FMP_EPAY_OPERATORID] = _origin_request[FMP_EPAY_OPERATORID].toVariant();
        hash[FMP_EPAY_BUSINESSDATE] = _origin_request[FMP_EPAY_BUSINESSDATE].toVariant();
        QJsonObject trans = _origin_request["transactions"].toObject();
        if (_origin_request["fm_cmd"].toInt() == 10031) {
            hash["amount"] = (int)(trans["order_amount"].toDouble()+0.005) - (int)(trans["paid_amount"].toDouble()+0.005);
        }
        else if (_origin_request["fm_cmd"].toInt() == 10041) {
            hash["amount"] = (int)(trans["refund_amount"].toDouble()+0.005);
            hash[FMP_JKEY_FM_ORDERID] = trans[FMP_JKEY_FM_ORDERID].toVariant();

//            if (trans.contains("refund_amount") && trans["refund_amount"].toInt() != 0
//                    && trans.contains(FMP_JKEY_FM_ORDERID) && !trans[FMP_JKEY_FM_ORDERID].toString().isEmpty()
//                    || trans.contains(FMP_JKEY_PAY_TRANSID) && !trans[FMP_JKEY_PAY_TRANSID].toString().isEmpty()) {
//                connect(this, &FMPePayPrivate::finished, this, &FMPePayPrivate::confirmClicked);
//                connect(this, &FMPePayPrivate::error, this, &FMPePayPrivate::confirmClicked);
//                ControlRefundJson(trans);
//                return;
//            }
        }
        else if(_origin_request["fm_cmd"].toInt() == 10030)
        {
            //组装支付查询接口的json
            QJsonObject obj;
            obj.insert(FMP_EPAY_STOREID,  q->_store_id);
            obj.insert(FMP_EPAY_STATIONID, q->_station_id);
            obj.insert(FMP_EPAY_OPERATORID, q->_operator_id);
            ControlQueryJson(obj);
        }
        QJsonArray pos_products = _origin_request["products"].toArray();
        QJsonArray products;
        int i = 1;
        foreach (QJsonValue v, pos_products) {
            QJsonObject o = v.toObject();
            o["seq"] = i++;
            products.append(o);
        }
        hash["products"] = products;
    }

    if(!(_origin_request["fm_cmd"].toInt() == 10030)) {


        if(_payDialog == nullptr) {
            _payDialog = new FMPPayDialog(this, hash);
        }
        else {
            _payDialog->setBasicInfo(hash);
        }

#ifdef GuestDisplay
        if(_amount > 0)
        {
            _payDialog->setAmount(_amount);
            _amount = 0;
        }
#endif

        _payDialog->show();

        if(_origin_request["fm_cmd"].toInt() == 10041 && !hash[FMP_JKEY_FM_ORDERID].toString().isEmpty()) {
            _payDialog->confirmRefund();
        }
    }
}

void FMPePayPrivate::clearorder()
{
    QtConcurrent::run( [&, this]()
    {
        Q_Q(FMPePay);

        FMPDataBase db(q->_databasename, QString("fmp_pay_clean")) ;

        QDateTime date = QDateTime::currentDateTime();
        QDateTime tmpdate = date.addDays(-(q->_ordershelflife));
        QString deletedate = tmpdate.toString("yyyy-MM-dd");

        FMP_INFO() << "deletedate" <<deletedate;

        db.dlt(q->_table, QString(QString(SQL_KEY_BUSSINEDATE) + "<datetime('%1')").arg(deletedate));

    });
}

#ifdef GuestDisplay
void FMPePayPrivate::SetAmount(int amount)
{
    if(_payDialog != NULL)
        _payDialog->setAmount(amount);
}
#endif

QSqlTableModel *FMPePayPrivate::model() const
{
    return _model;
}

void FMPePayPrivate::DockPayRequest(const QByteArray &json)
{
    _is_api = true;
    _api_abort = false;
    _origin_request = QJsonDocument::fromJson(json).object();
}

#define FMP_EPAY_STATUSCODE         "statusCode"
#define FMP_EPAY_ERRORMSG           "msg"
#define FMP_EPAY_FMID               "fm_id"
#define FMP_EPAY_PAYED_AMOUNT       "paid_total_amount"
#define FMP_EPAY_INVOICE_AMOUNT     "invoice_amount"
#define FMP_EPAY_DISCOUNT_AMOUNT    "discount_amount"
#define FMP_EPAY_PAY_IDS            "pay_ids"
#define FMP_EPAY_PAY_ID             "pay_id"
#define FMP_EPAY_PAY_DESC           "pay_str"


QByteArray FMPePayPrivate::DockPayRespond()
{
    QByteArray json = "{\"statusCode\":106, \"msg\":\"\347\252\227\345\217\243\345\267\262\345\205\263\351\227\255\357\274\214\344\272\244\346\230\223\345\217\226\346\266\210\", \"prompt\":0}";
    _api_evt.exec();

    if (!_api_abort) {
        _docked_response = QJsonObject();
        _docked_response[FMP_EPAY_STATUSCODE] = _origin_response[FMP_EPAY_STATUSCODE];
        _docked_response[FMP_EPAY_ERRORMSG] = _origin_response.contains("msg") ? _origin_response[FMP_EPAY_ERRORMSG] : QJsonValue("");
        _docked_response["prompt"] = 0;
        if (_origin_response["statusCode"].toInt() == 100) {
            _docked_response["fm_transId"] = _origin_response["pay_transId"];
            _docked_response[FMP_EPAY_FMID] = _origin_response["fmId"];
            _docked_response[FMP_EPAY_PAYED_AMOUNT] = _origin_response["total_amount"];
            _docked_response[FMP_EPAY_INVOICE_AMOUNT] = _origin_response[FMP_EPAY_INVOICE_AMOUNT];
            _docked_response[FMP_EPAY_DISCOUNT_AMOUNT] = _origin_response["mcoupon_amount"].toInt() + _origin_response["pcoupon_amount"].toInt();
            QJsonArray pay_channels;
            QJsonObject pay_ch;
            pay_ch[FMP_EPAY_PAY_ID] = _origin_response["pay_ebcode"];
            pay_ch[FMP_EPAY_PAY_DESC] = _origin_response["pay_id"];
            pay_ch["code"] = _origin_response["code"];
            pay_ch["pay_amount"] = _origin_response["total_amount"];
            pay_ch["pay_account"] = _origin_response["pay_acount"];
            pay_ch["platform_discount"] = _origin_response["mcoupon_amount"];
            pay_ch["merchant_discount"] = _origin_response["pcoupon_amount"];
            if (_origin_response.contains("ext")) {
                pay_ch["ext"] = _origin_response["ext"];
            }
            pay_channels.append(pay_ch);

            _docked_response[FMP_EPAY_PAY_IDS] = pay_channels;
        }

        _origin_response = QJsonObject();
        json = QJsonDocument(_docked_response).toJson();
    }

    return json;
}

void FMPePayPrivate::DockRefundRequest(const QByteArray &json)
{
    _is_api = true;
    _api_abort = false;
    _origin_request = QJsonDocument::fromJson(json).object();
}

QByteArray FMPePayPrivate::DockRefundRespond()
{
    QByteArray json = "{\"statusCode\":106, \"msg\":\"\347\252\227\345\217\243\345\267\262\345\205\263\351\227\255\357\274\214\344\272\244\346\230\223\345\217\226\346\266\210\", \"prompt\":0}";
    _api_evt.exec();

    //!
    if (!_api_abort) {
        _docked_response = QJsonObject();
        _docked_response["statusCode"] = _origin_response["statusCode"];
        if (_origin_response.contains("msg")) {
            _docked_response["msg"] = _origin_response["msg"];
        }
        if (_origin_response.contains("ext")) {
            _docked_response["ext"] = _origin_response["ext"];
        }
        _origin_response = QJsonObject();
        json = QJsonDocument(_docked_response).toJson();
    }

    return json;
}


void FMPePayPrivate::DockQueryRequest(const QByteArray &json)
{
    //!TODO DockQueryRequest()
    _is_api = true;
    _api_abort = false;
    _origin_request = QJsonDocument::fromJson(json).object();
}

QByteArray FMPePayPrivate::DockQueryRespond()
{
    //!TODO DockQueryRespond()
    QByteArray json = "{\"statusCode\":106, \"msg\":\"\347\252\227\345\217\243\345\267\262\345\205\263\351\227\255\357\274\214\344\272\244\346\230\223\345\217\226\346\266\210\", \"prompt\":0}";
    _api_evt.exec();

    if (!_api_abort) {
        _docked_response = QJsonObject();
        _docked_response[FMP_EPAY_STATUSCODE] = _origin_response[FMP_EPAY_STATUSCODE];
        _docked_response[FMP_EPAY_ERRORMSG] = _origin_response.contains("msg") ? _origin_response[FMP_EPAY_ERRORMSG] : QJsonValue("");
        _docked_response["prompt"] = 0;
        if (_origin_response["statusCode"].toInt() == 100) {
            _docked_response["fm_transId"] = _origin_response["pay_transId"];
            _docked_response[FMP_EPAY_FMID] = _origin_response["fmId"];
            _docked_response[FMP_EPAY_PAYED_AMOUNT] = _origin_response["total_amount"];
            _docked_response[FMP_EPAY_INVOICE_AMOUNT] = _origin_response[FMP_EPAY_INVOICE_AMOUNT];
            _docked_response[FMP_EPAY_DISCOUNT_AMOUNT] = _origin_response["mcoupon_amount"].toInt() + _origin_response["pcoupon_amount"].toInt();
            QJsonArray pay_channels;
            QJsonObject pay_ch;
            pay_ch[FMP_EPAY_PAY_ID] = _origin_response["pay_ebcode"];
            pay_ch[FMP_EPAY_PAY_DESC] = _origin_response["pay_id"];
            pay_ch["code"] = _origin_response["code"];
            pay_ch["pay_amount"] = _origin_response["total_amount"];
            pay_ch["pay_account"] = _origin_response["pay_acount"];
            pay_ch["platform_discount"] = _origin_response["mcoupon_amount"];
            pay_ch["merchant_discount"] = _origin_response["pcoupon_amount"];
            if (_origin_response.contains("ext")) {
                pay_ch["ext"] = _origin_response["ext"];
            }
            pay_channels.append(pay_ch);

            _docked_response[FMP_EPAY_PAY_IDS] = pay_channels;
        }
        else
        {
            _docked_response = QJsonDocument::fromJson(json).object();
        }

        _origin_response = QJsonObject();
        json = QJsonDocument(_docked_response).toJson();
    }

    return json;
}


void FMPePayPrivate::OnFinish()
{
    if (_origin_response.isEmpty()) {
        _api_abort = true;
    }

    emit confirmClicked();
    _api_evt.quit();
}

void FMPePayPrivate::ControlPayJson(QString sum, QString code)
{
    QtConcurrent::run( [&, sum, code, this]()
    {
        Q_Q(FMPePay);

        _origin_response = QJsonObject();

        if(_reverse_flag)
        {
            emit error(QString::fromLocal8Bit("网络连接异常(冲正...)"));
            _origin_response["statusCode"] = 104;
            _origin_response["msg"] = QString::fromLocal8Bit("网络连接异常");
            _origin_response["prompt"] = 0;
            emit apiError();
            return ;
        }

        if(!GetPayJson(sum, code))
        {
            emit error(QString::fromLocal8Bit("获取门店信息失败"));
            _origin_response["statusCode"] = 109;
            _origin_response["msg"] = QString::fromLocal8Bit("获取门店信息失败");
            _origin_response["prompt"] = 0;
            emit apiError();
            return ;
        }

        FMP_INFO() << "pay json : " << _docked_request;

        QString errors;
        QJsonObject outjson;

        if(!HttpPost(outjson, _docked_request ,errors, q->_time_out))
        {
            _origin_response = outjson;
            emit error(errors);
            emit apiError();
        }
        else
        {
            outjson.insert(SQL_KEY_ISREFUND, false);
            outjson.insert(SQL_KEY_CODE, code);
            outjson.insert(SQL_KEY_BUSSINEDATE, q->_businessdate);
            outjson.insert(SQL_KEY_TRANSID, _docked_request[SQL_KEY_TRANSID].toString());

            _db->insert(q->_table, outjson.toVariantHash());
            if (_is_api) {
                _origin_response = outjson;
            }
            emit finished(outjson);
        }
    });
}

//void FMPePayPrivate::ControlPayJson(QString sum, QString code)
//{
//    Q_Q(FMPePay);

//    QByteArray data = "{ \"reqtype\" : 0}";

//    HttpPost(q->_url, data, _watcher);

//    qDebug() << "***********************" <<_watcher->future().result();
//}

void FMPePayPrivate::witedata()
{
    qDebug() << _watcher->future().result();
}

void FMPePayPrivate::HttpPost(const QString &url, const QByteArray &data, QFutureWatcher<QByteArray> *watcher, int timeout)
{
    QFuture<QByteArray> furture = QtConcurrent::run( [url, data, timeout, this]()->QByteArray
    {
        QEventLoop loop;
        QTimer timer;

        QNetworkAccessManager manger;
        QNetworkRequest request(url);

        request.setRawHeader("Content-Type","text/json");

        QNetworkReply* reply = manger.post(request, data);

        connect(&timer, &QTimer::timeout, &loop, &QEventLoop::quit);
        connect(&manger, &QNetworkAccessManager::finished, &loop, &QEventLoop::quit);
        connect(reply, static_cast<void (QNetworkReply::*)(QNetworkReply::NetworkError)>(&QNetworkReply::error), &loop, &QEventLoop::quit);
        timer.start(timeout*1000);

        loop.exec();

        reply->deleteLater();

        if(reply->error() != QNetworkReply::NoError)
        {
            return QByteArray();
        }

        return reply->readAll();
    });
    watcher->setFuture(furture);
}

bool FMPePayPrivate::HttpPost(QJsonObject& outjson, QJsonObject json, QString &error, int timeout)
{
    qDebug() << "------------------1-----------------------";
    Q_Q(FMPePay);
    QEventLoop loop;
    QTimer timer;

    QSslConfiguration config;
    QList<QSslCertificate> certs = QSslCertificate::fromPath(qApp->applicationDirPath() + "/client01.pem");
    config.setPeerVerifyMode(QSslSocket::VerifyNone);
    config.setProtocol(QSsl::SslV3);
    config.setCaCertificates(certs);

    QNetworkAccessManager manger;
    QNetworkRequest request(q->_url);

    request.setSslConfiguration(config);
    request.setRawHeader("Content-Type","text/json");
    qDebug() << "------------------2-----------------------";

    QNetworkReply* reply = manger.post(request, QJsonDocument(json).toJson());

    connect(&timer, &QTimer::timeout, &loop, &QEventLoop::quit);
    connect(&manger, &QNetworkAccessManager::finished, &loop, &QEventLoop::quit);
    connect(reply, static_cast<void (QNetworkReply::*)(QNetworkReply::NetworkError)>(&QNetworkReply::error), &loop, &QEventLoop::quit);
    timer.start(timeout*1000);

    loop.exec();

    reply->deleteLater();
    qDebug() << "------------------3-----------------------";

    if(reply->error() != QNetworkReply::NoError)
    {
        qDebug() << "------------------41-----------------------";
        error = QString::fromLocal8Bit("网络异常");
        return false;
    }
    qDebug() << "------------------4-----------------------";

    if(!CheckReturnJson(reply->readAll(), outjson))
    {
        error = QString::fromLocal8Bit("返回数据错误");
        return false;
    }

    qDebug() << "------------------7-----------------------";
    FMP_INFO() << outjson;

    int statusCode = outjson[FMP_RPAY_PAY_RETURN_STATUSCODE].toInt();
    int reqType = json[FMP_EPAY_REQUESTTYPE].toInt();
    if(statusCode == 100)
       return true;

    if (statusCode == 204 && reqType == 72) {
        QJsonObject queryJson = json;
        queryJson[FMP_EPAY_REQUESTTYPE] = 52;
        queryJson[FMP_EPAY_VER] = 3;
        FMP_INFO() << "Query: " << json[FMP_EPAY_TRANSID].toString();
        QJsonObject queryOutJson;
        if (!HttpPost(queryOutJson, queryJson, error, timeout)) {
            QJsonObject revokeJson = json;
            revokeJson[FMP_EPAY_REQUESTTYPE] = 3;
            QJsonObject revokeOutJson;
            HttpPost(revokeOutJson, revokeJson, error, timeout);
            error = QString::fromLocal8Bit("支付失败，请重试\r\n如已扣款会自动退还");
            return false;
        }
        else {
            outjson = queryOutJson;
        }
    }
    if(outjson.contains(FMP_RPAY_PAY_RETURN_MSG)) {
        error = outjson[FMP_RPAY_PAY_RETURN_MSG].toString() + QString("[%1]").arg(outjson[FMP_RPAY_PAY_RETURN_STATUSCODE].toInt());
    } else {
        QString errorDesc;

        switch(statusCode) {
        case 21:
            errorDesc = QString::fromLocal8Bit("参数错误");
            break;
        case 41:
            errorDesc = QString::fromLocal8Bit("交易不存在");
            break;
        case 203:
            errorDesc = QString::fromLocal8Bit("余额不足");
            break;
        case 205:
            errorDesc = QString::fromLocal8Bit("支付码错误");
            break;
        default:
            errorDesc = QString::fromLocal8Bit("未定义错误");
            break;
        }

        error = errorDesc + QString("[%1]").arg(outjson[FMP_RPAY_PAY_RETURN_STATUSCODE].toInt());
    }
    return false;

}

bool FMPePayPrivate::CheckReturnJson(QByteArray data, QJsonObject &returnjson)
{
    QJsonParseError json_error;
    QJsonDocument doc = QJsonDocument::fromJson( data, &json_error);

    qDebug() << "------------------5-----------------------";
    if(json_error.error != QJsonParseError::NoError || !doc.isObject())
    {
        return false;
    }
    qDebug() << "------------------6-----------------------";
    returnjson = doc.object();

    FMP_INFO() << "get return json : " << returnjson;

    return true;
}

void FMPePayPrivate::SetBasicInfo(QVariantHash hash)
{
    if(_payDialog != NULL)
        _payDialog->setBasicInfo(hash);
}

#ifdef GuestDisplay
void FMPePayPrivate::SetAmoumt(int amount)
{
    FMP_INFO() << "###------------------SetAmoumt amount : " << amount;    
    if(_payDialog != NULL)
        _payDialog->setAmount(amount);
    else
       _amount = amount;
}
#endif

void FMPePayPrivate::GetCheckMode(QString sum)
{
    QString sql = QString("fmId like '%%%1%%' or pay_transId like '%%%1%%'").arg(sum);
    _model->setFilter(sql);
    _model->select();
}

void FMPePayPrivate::GetMode()
{
    _model->setFilter(QString(""));
    _model->select();
}


void FMPePayPrivate::ControlRefundJson(const QJsonObject &trans)
{
    QtConcurrent::run( [&, trans, this]()
    {
        Q_Q(FMPePay);

        _origin_response = QJsonObject();

        QStringList keylist;
        QSqlQuery query;
        keylist.append(SQL_KEY_EBCODE);
        keylist.append(SQL_KEY_TRANSID);
        bool dock_success = false;
        if(_reverse_flag) {
            emit error(QString::fromLocal8Bit("网络连接异常(冲正...)"));
            _origin_response["statusCode"] = 104;
            _origin_response["msg"] = QString::fromLocal8Bit("网络连接异常");
            _origin_response["prompt"] = 0;
            emit apiError();
            return ;
        }

        QString payTransId = trans[FMP_JKEY_PAY_TRANSID].toString();
        QString fmTransId = trans[FMP_JKEY_FM_ORDERID].toString();
        QJsonObject t = trans;
        if (!payTransId.isEmpty()) {
            if(!_db->find(q->_table, query, keylist, QString(QString(SQL_KEY_PAYTRANSID) + " = '%1'").arg(payTransId)) || !query.next()) {
                _origin_response["statusCode"] = 108;
                _origin_response["msg"] = QString::fromLocal8Bit("交易记录不存在");
                _origin_response["prompt"] = 0;
                emit error(QString::fromLocal8Bit("交易记录不存在"));
                emit apiError();
                return;
            }
            else {
                t[FMP_JKEY_PAY_EBCODE] = query.value(0).toString();
                t[FMP_JKEY_POS_TRANSID] = query.value(1).toString();
            }
        }

        if(!GetRefundJson(t)) {
            emit error(QString::fromLocal8Bit("获取门店信息失败"));
            _origin_response["statusCode"] = 109;
            _origin_response["msg"] = QString::fromLocal8Bit("获取门店信息失败");
            _origin_response["prompt"] = 0;
            emit apiError();
            return;
        }

        FMP_INFO() << "refund json : " << _docked_request;

        QString errors;
        QJsonObject outjson;

        if(!HttpPost(outjson, _docked_request ,errors, q->_time_out)) {
            emit error(errors);
            _origin_response = outjson;
        }
        else {
            dock_success = true;
            QVariantHash hash;
            QSqlQuery tmpquery;
            QStringList tmpkeylist;
            tmpkeylist << SQL_KEY_PAYTRANSID << SQL_KEY_FMID << SQL_KEY_PAYID;

            hash.insert(SQL_KEY_ISREFUND, true);
            hash.insert(SQL_KEY_REFUND_DATE, QDateTime::currentDateTime().toString("yyyy-MM-dd"));


            if(!_db->update(q->_table, hash, QString("pay_transId = '%1' or fmId = '%2'").arg(payTransId).arg(fmTransId)))
            {
                FMP_ERROR() << "refund data update failed";
            }

            if(!_db->find(q->_table, tmpquery, tmpkeylist,  QString("pay_transId = '%1' or fmId = '%2'").arg(payTransId).arg(fmTransId)) || !tmpquery.next())
            {
                FMP_ERROR() << "refund data update failed";

                outjson.insert(SQL_KEY_PAYTRANSID, payTransId);
                outjson.insert(SQL_KEY_FMID, fmTransId);
                outjson.insert(SQL_KEY_PAYID, QString::fromLocal8Bit("未知"));
                outjson.insert(SQL_KEY_TOTALAMOUNT, trans[FMP_JKEY_REFUND_AMOUNT]);
            }
            else
            {
                outjson.insert(SQL_KEY_PAYTRANSID, tmpquery.value(0).toString());
                outjson.insert(SQL_KEY_FMID, tmpquery.value(1).toString());
                outjson.insert(SQL_KEY_PAYID, tmpquery.value(2).toString());
                outjson.insert(SQL_KEY_TOTALAMOUNT, trans[FMP_JKEY_REFUND_AMOUNT]);
            }

            FMP_INFO() << "refund success view json : " << outjson;

            _model->setFilter(QString(""));
            _model->select();

            if (_is_api) {
                _origin_response = outjson;
            }
            emit finished(outjson);
        }

        if (!dock_success) {
            emit apiError();
        }

//        disconnect(this, &FMPePayPrivate::finished, this, &FMPePayPrivate::confirmClicked);
//        connect(this, &FMPePayPrivate::error, this, &FMPePayPrivate::confirmClicked);
    });
}

void FMPePayPrivate::ControlQueryJson(const QJsonObject &trans)
{
    QtConcurrent::run( [&, trans, this]()
    {
        Q_Q(FMPePay);

        _origin_response = QJsonObject();

        if(_reverse_flag) {
            emit error(QString::fromLocal8Bit("网络连接异常(冲正...)"));
            _origin_response["statusCode"] = 104;
            _origin_response["msg"] = QString::fromLocal8Bit("网络连接异常");
            _origin_response["prompt"] = 0;
            emit apiError();
            return ;
        }

        _docked_request = trans;

        _docked_request[FMP_EPAY_VER] = 3;
        _docked_request[FMP_EPAY_REQUESTTYPE] = 52;
        _docked_request[FMP_EPAY_TRANSID] = _origin_request[FMP_EPAY_TRANSID].toString();
        _docked_request[FMP_EPAY_FMID] = _origin_request[FMP_JKEY_FM_ORDER_ID].toString();
        _docked_request[FMP_EPAY_REFUND_ID] = _origin_request[FMP_EPAY_REFUND_ID].toInt();

        FMP_INFO() << "query json : " << _docked_request;

        QString errors;
        QJsonObject outjson;

        if(!HttpPost(outjson, _docked_request ,errors, q->_time_out))
        {
           qDebug() << "------------------42-----------------------";
            _origin_response = outjson;
            emit error(errors);
            emit apiError();

            qDebug() << "------------------43-----------------------";
        }
        else
        {
            if (_is_api) {
                _origin_response = outjson;
                qDebug() << "_origin_response" << _origin_response;
            }
//            emit finished(outjson);
        }
        _api_evt.quit();
    qDebug() << "------------------44-----------------------";
    });
}

void FMPePayPrivate::ControlReverseJson()
{
    _reverse_flag = true;

    GetReverseJson();

    qDebug() << "using network send Reverse data to server";
    qDebug() << _docked_request;
}

bool FMPePayPrivate::GetPayJson(const QString& sum, const QString& code)
{
    Q_Q(FMPePay);

    _docked_request = QJsonObject::fromVariantMap( QVariantMap() );

    QJsonObject transaction;
    QJsonArray transactionarry;


    /**
     * settings get store infomation(or return false)
     **/
    qDebug() << "get store infomation from settings";

    int ver = 2;

    transaction.insert(FMP_EPAY_TRANSTRACTION_CODE,  code);
    if (_is_api) {
//        QJsonObject origin_trans = _origin_request["transactions"].toObject();
        transaction[FMP_EPAY_TRANSTRACTION_AMOUNT] = _payDialog->getPayAmount();
        QJsonObject pos_trans = _origin_request["transactions"].toObject();
        QJsonArray pos_products = pos_trans["products"].toArray();
        QJsonArray products;
        int i = 1;
        foreach (QJsonValue v, pos_products) {
            QJsonObject o = v.toObject();
            o["seq"] = i++;
            products.append(o);
        }
        transaction["products"] = products;
        _docked_request[FMP_EPAY_STOREID] = _origin_request[FMP_EPAY_STOREID];
        _docked_request[FMP_EPAY_STATIONID] = _origin_request["pos_id"];
        _docked_request[FMP_EPAY_OPERATORID] = _origin_request[FMP_EPAY_OPERATORID];
        _docked_request[FMP_EPAY_BUSINESSDATE] = _origin_request[FMP_EPAY_BUSINESSDATE];
    }
    else {
        transaction.insert(FMP_EPAY_TRANSTRACTION_AMOUNT, (int)((sum.toDouble() + 0.005) * 100));
        _docked_request.insert( FMP_EPAY_BUSINESSDATE, q->_businessdate);
        _docked_request.insert( FMP_EPAY_STOREID, q->_store_id);
        _docked_request.insert( FMP_EPAY_STATIONID, q->_station_id);
        _docked_request.insert( FMP_EPAY_OPERATORID, q->_operator_id);
    }

    transactionarry.append( transaction);

    _docked_request.insert( FMP_EPAY_VER, ver);
    _docked_request.insert( FMP_EPAY_REQUESTTYPE, 72);
    _docked_request.insert( FMP_EPAY_PARTNERID, q->_partner_id.toInt());
    _docked_request.insert( FMP_EPAY_CLIENTREQCOUNT, (int)((++s_ClientReqCount)%=10000000));

//    _docked_request.insert( FMP_EPAY_TRANSID, QDateTime::currentDateTime().toString("yyyyMMddhhmmsszzz"));
    _docked_request.insert(FMP_EPAY_TRANSID, _origin_request[FMP_EPAY_TRANSID].toString());
    _docked_request.insert( FMP_EPAY_TRANSTRACTION, transactionarry);

    return true;
}

bool FMPePayPrivate::GetRefundJson(const QJsonObject &trans)
{
    Q_Q(FMPePay);
    _docked_request = QJsonObject::fromVariantMap( QVariantMap() );

    QJsonObject transaction;
    QJsonArray transactionarry;


    /**
     * settings get store infomation(or return false)
     **/
    qDebug() << "get store infomation from settings";

    int ver = 2;

    if(trans.contains(FMP_JKEY_FM_ORDERID) && !trans[FMP_JKEY_FM_ORDERID].toString().isEmpty())
    {
        transaction.insert(FMP_EPAY_REFUND_TRANSTRACTION_FMID,  trans[FMP_JKEY_FM_ORDERID]);
        if (_is_api) {
            QJsonObject orig_trans = _origin_request["transactions"].toObject();
            transaction.insert(FMP_EPAY_REFUND_TRANSTRACTION_AMOUNT, (int)(orig_trans["refund_amount"].toDouble() + 0.005));
        }
        else {
            transaction.insert(FMP_EPAY_REFUND_TRANSTRACTION_AMOUNT, (int)(trans[FMP_JKEY_REFUND_AMOUNT].toDouble() + 0.005));
        }
//        _docked_request.insert(FMP_EPAY_TRANSID, QDateTime::currentDateTime().toString("yyyyMMddhhmmsszzz"));
        _docked_request.insert(FMP_EPAY_TRANSID, _origin_request[FMP_EPAY_TRANSID].toString());
    }
    else {
        transaction.insert(FMP_EPAY_REFUND_TRANSTRACTION_EBCODE,  trans[FMP_JKEY_PAY_EBCODE]);
        transaction.insert(FMP_EPAY_REFUND_TRANSTRACTION_TRANSID,  trans[FMP_JKEY_PAY_TRANSID]);
        transaction.insert(FMP_EPAY_REFUND_TRANSTRACTION_AMOUNT, (int)(trans[FMP_JKEY_REFUND_AMOUNT].toDouble() + 0.005));
        _docked_request.insert(FMP_EPAY_TRANSID, trans[FMP_JKEY_POS_TRANSID]);
    }

    transactionarry.append( transaction);

    _docked_request.insert( FMP_EPAY_VER, ver);
    _docked_request.insert( FMP_EPAY_REQUESTTYPE, 62);
    _docked_request.insert( FMP_EPAY_PARTNERID, q->_partner_id.toInt());
    _docked_request.insert( FMP_EPAY_CLIENTREQCOUNT, (int)((++s_ClientReqCount)%=10000000));
    //添加refund_id字段
    _docked_request.insert( FMP_EPAY_REFUND_ID, (int)QDateTime::currentDateTime().toTime_t());

    if (_is_api) {
        _docked_request[FMP_EPAY_STOREID] = _origin_request[FMP_EPAY_STOREID];
        _docked_request[FMP_EPAY_STATIONID] = _origin_request["pos_id"];
        _docked_request[FMP_EPAY_OPERATORID] = _origin_request[FMP_EPAY_OPERATORID];
        _docked_request[FMP_EPAY_BUSINESSDATE] = _origin_request[FMP_EPAY_BUSINESSDATE];
        _docked_request.insert( FMP_EPAY_TRANSTRACTION, transactionarry);
    }
    else {
        _docked_request.insert( FMP_EPAY_STOREID, q->_store_id);
        _docked_request.insert( FMP_EPAY_STATIONID, q->_station_id);
        _docked_request.insert( FMP_EPAY_OPERATORID, q->_operator_id);
        _docked_request.insert( FMP_EPAY_TRANSTRACTION, transactionarry);
    }

    return true;
}

void FMPePayPrivate::GetReverseJson()
{
    _docked_request[FMP_EPAY_REQUESTTYPE] = 3;
}
