﻿#ifndef FMP_EPAY_H
#define FMP_EPAY_H

#include <QObject>
#include <QPointer>
#include "fmp_epay_i.h"


class FMPePayPrivate;
class FMPStartEventHandler;

class FMPePay : public FMPePayInterface
{
    Q_OBJECT
    Q_INTERFACES(FMPBaseInterface)
    Q_INTERFACES(FMPluginInterface)
    Q_INTERFACES(FMPePayInterface)
    Q_DECLARE_PRIVATE(FMPePay)

public:
    explicit            FMPePay(ctkPluginContext *context);
    virtual             ~FMPePay();

    void                SetBasicInfo(QVariantHash hash);
    void                DockPayRequest(const QByteArray &json);
    QByteArray          DockPayRespond();

    void                DockRefundRequest(const QByteArray &json);
    QByteArray          DockRefundRespond();

    void                DockQueryRequest(const QByteArray &json);
    QByteArray          DockQueryRespond();

#ifdef GuestDisplay
public slots:
    void OnAmountChange(int amount);

#endif

protected slots:
    void                InitService();
    void                UninitService();


private:
    bool                _inited;
    //bool                _needanimation;
    QString             _url;
    QString             _databasename;
    QString             _table;
    QString             _businessdate;
    QString             _store_id;
    QString             _station_id;
    QString             _operator_id;
    QString             _partner_id;
    int                 _time_out;


    //销售单保存时间
    int                 _ordershelflife;

    FMPePayPrivate*     d_ptr;

    QPointer<FMPStartEventHandler> _ste_handler;
};

#endif // FMP_EPAY_H
