﻿#ifndef DIALOG_H
#define DIALOG_H

#include <QJsonObject>
#include <QJsonArray>
#include <QVariantHash>
#include <QJsonDocument>
#include <QModelIndex>
#include <QDateTime>
#include <QTimer>

#include <QDialog>
#include <QLineEdit>
#include "fmp_epayview_wait.h"
#include "fmp_epayview_focuslineedit.h"

class FMPePayPrivate;
class FMPLoggerInterface;

namespace Ui {
class FMPPayDialog;
}

class FMPPayDialog : public QDialog
{
    Q_OBJECT

typedef enum
{
    TopToBtm = 0,
    BtmToTop,
    LeftToRight,
    RightToLeft
} Movemode;

public:
    explicit FMPPayDialog(FMPePayPrivate *control, QVariantHash basicinfo, QWidget *parent = 0);

    void show();

    ~FMPPayDialog();

    int getPayAmount() const;

    void confirmRefund();

public slots:
    void showErrorMsg(QString errormsg);

    void showSuccessMsg(QJsonObject json);

    void onSelectionChanged(QModelIndex idx);

    void setBasicInfo(QVariantHash basicinfo);

    void timerHandle();    //定时关闭支付成功窗口
protected:

    void keyPressEvent(QKeyEvent *);

    void mousePressEvent(QMouseEvent *);
    void mouseMoveEvent(QMouseEvent *);
    void mouseReleaseEvent(QMouseEvent *);

private slots:
    void onWidgetChange();

    void onBtnNumClicked();

    void onBtnConfirmClicked();

    void on_btn_backspace_clicked();

    void on_btn_clear_clicked();

    void on_btn_close_clicked();

    void onLineeditCodeGetFocus();

    void on_btn_success_confirm_clicked();

    void on_btn_paycheck_clicked();

    void on_pushButton_2_clicked();

    void on_btn_clear_refund_clicked();

    void on_btn_backspace_refund_clicked();

    void on_lineEdit_textChanged(const QString &arg1);

    void reject();
public:
    void setPayView();

    void setRefundView();

private:

    void setCheckView();

    void setPaySuccessView(QJsonObject json);

    void setRefundSuccessView(QJsonObject json);

    bool CheckLineEditSum(QString sum);

    bool CheckLineEditCode(QString code);

    //-----------
    void PlayAnimation(QWidget* target0, QWidget* target1, Movemode movemode);

private:
    Ui::FMPPayDialog *ui;

    FMPFocusLineEdit *_current_LineEdit;

    FMPePayPrivate *_control;

    FMPPayWait *_wait;

    //----------
    QPushButton* _curt_btn;

    bool _success_flag;
    bool _is_amt;
    bool _needanimation;
    bool _b_mouse_pressed;
    bool _is_api;
    QPoint      _mMovePosition;
    QTimer *_wnd_close_timer;
    int _seconds;
    bool _isConfirmRefund;
};

#endif // DIALOG_H
