﻿#include "fmp_epayview_dialog.h"
#include "ui_fmp_epayview_dialog.h"
#include "fmp_epay_def.h"
#include "fmp_epay_p.h"
#include "fmp_epay_checkmodel.h"
#include "fmp_epay_plugin_p.h"

#include <QDebug>
#include <fmp_settings_i.h>
#include <fmp_logger_i.h>
#include <QSqlTableModel>
#include <QStyledItemDelegate>
#include <QMouseEvent>
#include <Windows.h>
#include <QDesktopWidget>

#include <QPropertyAnimation>


FMPPayDialog::FMPPayDialog(FMPePayPrivate *control, QVariantHash basicinfo, QWidget *parent) :
    _control(control),
    QDialog(parent),
    ui(new Ui::FMPPayDialog),
    _isConfirmRefund(false)
{

    ui->setupUi(this);

    //this->setWindowIconText(QString::fromLocal8Bit("非码支付"));
    this->setWindowTitle(QString::fromLocal8Bit("非码支付"));

    _b_mouse_pressed = false;

    _needanimation = basicinfo[FMP_EPAY_ANIMATION].toBool();

    ui->label_date->setText(QString::fromLocal8Bit("当前营业日 : ") + basicinfo[FMP_EPAY_BUSINESSDATE].toString());
    ui->label_storeid->setText(QString::fromLocal8Bit("门店号:") + basicinfo[FMP_EPAY_STOREID].toString());
    ui->label_posno->setText(QString::fromLocal8Bit("POS编号:") + basicinfo[FMP_EPAY_STATIONID].toString());
    ui->label_optid->setText(QString::fromLocal8Bit("操作员:") + basicinfo[FMP_EPAY_OPERATORID].toString());

    _wait = NULL;
    _success_flag = false;
    _is_amt = false;

    this->setWindowFlags( windowFlags() | Qt::WindowStaysOnTopHint | Qt::FramelessWindowHint);
    this->setWindowFlags(Qt::FramelessWindowHint);
    setAttribute(Qt::WA_QuitOnClose, false);

    connect(ui->btn_num0, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num00, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num1, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num2, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num3, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num4, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num5, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num6, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num7, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num8, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num9, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_numdot, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);

    connect(ui->btn_num0_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num00_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num1_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num2_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num3_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num4_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num5_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num6_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num7_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num8_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_num9_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);
    connect(ui->btn_numdot_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnNumClicked);

    connect(ui->btn_confirm01, &QPushButton::clicked, this, &FMPPayDialog::onBtnConfirmClicked);
    connect(ui->btn_confirm01_refund, &QPushButton::clicked, this, &FMPPayDialog::onBtnConfirmClicked);
    connect(ui->lineedit_code, &FMPFocusLineEdit::returnPressed, this, &FMPPayDialog::onBtnConfirmClicked);



    connect(ui->lineedit_num_refund, &FMPFocusLineEdit::focusIn, this, &FMPPayDialog::onLineeditCodeGetFocus);
    connect(ui->lineedit_code_refund, &FMPFocusLineEdit::focusIn, this, &FMPPayDialog::onLineeditCodeGetFocus);
    connect(ui->lineedit_code_refund, &FMPFocusLineEdit::returnPressed, this, &FMPPayDialog::onBtnConfirmClicked);

    connect(ui->lineedit_num, &FMPFocusLineEdit::focusIn, this, &FMPPayDialog::onLineeditCodeGetFocus);
    connect(ui->lineedit_code, &FMPFocusLineEdit::focusIn, this, &FMPPayDialog::onLineeditCodeGetFocus);

    connect(ui->btn_pay, &QPushButton::clicked, this, &FMPPayDialog::onWidgetChange);
    connect(ui->btn_check, &QPushButton::clicked, this, &FMPPayDialog::onWidgetChange);
    connect(ui->btn_refund, &QPushButton::clicked, this, &FMPPayDialog::onWidgetChange);


    connect(_control, &FMPePayPrivate::error, this, &FMPPayDialog::showErrorMsg);
    connect(_control, &FMPePayPrivate::finished, this, &FMPPayDialog::showSuccessMsg);

    connect(ui->btn_close, &QPushButton::clicked, _control, &FMPePayPrivate::OnFinish, Qt::QueuedConnection);
    connect(ui->btn_success_confirm, &QPushButton::clicked, _control, &FMPePayPrivate::OnFinish, Qt::QueuedConnection);
    connect(this, &FMPPayDialog::accepted, _control, &FMPePayPrivate::OnFinish, Qt::QueuedConnection);
    connect(this, &FMPPayDialog::rejected, _control, &FMPePayPrivate::OnFinish, Qt::QueuedConnection);


    ui->lineedit_num->setFocus();
    _current_LineEdit = ui->lineedit_num;


    ui->tableView->setEditTriggers(QAbstractItemView::NoEditTriggers);
    ui->tableView->setItemDelegate(new FMPPayItemDelegate);
    connect(ui->tableView, SIGNAL(clicked(QModelIndex)), SLOT(onSelectionChanged(QModelIndex)));

    QSqlTableModel *model = _control->model();

    model->setHeaderData(0, Qt::Horizontal, QString::fromLocal8Bit("非码交易号"));
    model->setHeaderData(4, Qt::Horizontal, QString::fromLocal8Bit("交易渠道"));
    model->setHeaderData(6, Qt::Horizontal, QString::fromLocal8Bit("金额(元)"));
    model->setHeaderData(11, Qt::Horizontal, QString::fromLocal8Bit("营业日期"));
    model->setHeaderData(12, Qt::Horizontal, QString::fromLocal8Bit("退款"));

    ui->tableView->setModel(model);

    ui->tableView->hideColumn(1);
    ui->tableView->hideColumn(2);
    ui->tableView->hideColumn(3);
    ui->tableView->hideColumn(5);
    ui->tableView->hideColumn(7);
    ui->tableView->hideColumn(8);
    ui->tableView->hideColumn(9);
    ui->tableView->hideColumn(10);
    ui->tableView->hideColumn(13);

    ui->tableView->setSelectionMode(QTableView::SingleSelection);
    ui->tableView->setSelectionBehavior(QTableView::SelectRows);

    ui->tableView->verticalHeader()->setVisible(false);
    QHeaderView *header = ui->tableView->horizontalHeader();
    ui->tableView->setColumnWidth(0, 200);
    //ui->tableView->setColumnWidth(2, 220);
    ui->tableView->setColumnWidth(4, 160);
    ui->tableView->setColumnWidth(6, 100);
    ui->tableView->setColumnWidth(11, 100);

    header->setVisible(true);
    header->setStretchLastSection(true);

    QRegExp rx("^(([1-9]+)|([0-9]+.[0-9]{1,2}))$");
    QRegExpValidator *pReg = new QRegExpValidator(rx, this);
    ui->lineedit_num->setValidator(pReg);

    QRegExp rxs("^[A-Za-z0-9]+$");
    QRegExpValidator *pRegs = new QRegExpValidator(rxs, this);
    ui->lineedit_code->setValidator(pRegs);

    _curt_btn = ui->btn_pay;

    ui->wdg_query_main->move(0, ui->wdg_query_main->height());
    ui->wdg_refund_main->move(0, ui->wdg_query_main->height());
    ui->wdg_success_main->move(0, ui->wdg_success_main->height());
    ui->wdg_pay_main->move(0, 0);

    if (basicinfo["fm_cmd"].toInt() == 10031) {
        ui->btn_pay->click();
        ui->lineedit_num->setText(QString::number(basicinfo["amount"].toDouble() / 100));
        ui->lineedit_num->setEnabled(false);
        ui->lineedit_code->setFocus();
    }
    else if (basicinfo["fm_cmd"].toInt() == 10041) {
        ui->btn_refund->click();
        ui->lineedit_code_refund->setFocus();
        ui->lineedit_num_refund->setText(QString::number(basicinfo["amount"].toDouble() / 100));
        ui->lineedit_num_refund->setEnabled(false);
        ui->lineedit_code_refund->setText(basicinfo[FMP_JKEY_FM_ORDERID].toString());
    }

    if (basicinfo["fm_cmd"].toInt() == 10031 || basicinfo["fm_cmd"].toInt() == 10041) {
        ui->btn_check->setEnabled(false);
        ui->btn_refund->setEnabled(false);
        ui->btn_pay->setEnabled(false);
    }

    _wnd_close_timer=new QTimer(this);
    connect(_wnd_close_timer,SIGNAL(timeout()),this,SLOT(timerHandle()));
    _seconds=_control->auto_close_seconds;
}

int FMPPayDialog::getPayAmount() const
{
    int amount = (ui->lineedit_num->text().toDouble()+0.005) * 100;
    return amount;
}

void FMPPayDialog::confirmRefund()
{
    _isConfirmRefund = true;
    onBtnConfirmClicked();
}

void FMPPayDialog::show()
{

    showNormal();
    ::SetForegroundWindow((HWND)effectiveWinId());

    ::SetWindowPos( (HWND)effectiveWinId(), HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_SHOWWINDOW);

    showNormal();
    ::SetForegroundWindow((HWND)effectiveWinId());


    QDesktopWidget w;
    QRect rc = w.availableGeometry();
    setGeometry((rc.width() - width()) / 2, (rc.height() - height()) / 2, width(), height());

    return QDialog::show();
}

void FMPPayDialog::onWidgetChange()
{
    QPushButton *tmpcur = _curt_btn;

    if(_is_amt)
    {
        return ;
    }

    if(_success_flag)
    {
        _success_flag = false;
        _curt_btn = (QPushButton *)sender();
        QWidget *nextwdg = findChild<QWidget *>(_curt_btn->property("pageName").toString());
        PlayAnimation(ui->wdg_success_main, nextwdg, LeftToRight);

        if(_curt_btn->property("index").toInt() == 0)
            setPayView();

        if(_curt_btn->property("index").toInt() == 1)
            setRefundView();

        if(_curt_btn->property("index").toInt() == 2)
            setCheckView();

        return ;
    }

    if(_curt_btn == sender())
    {
        return ;
    }

    _curt_btn = (QPushButton *)sender();

    if(_curt_btn->property("index").toInt() == 0)
        setPayView();

    if(_curt_btn->property("index").toInt() == 1)
        setRefundView();

    if(_curt_btn->property("index").toInt() == 2)
        setCheckView();

    Movemode move = BtmToTop;

    QWidget *nextwdg = findChild<QWidget *>(_curt_btn->property("pageName").toString());
    QWidget *currwdg = findChild<QWidget *>(tmpcur->property("pageName").toString());


    if(_curt_btn->property("index").toInt() < tmpcur->property("index").toInt())
        move = TopToBtm;

    PlayAnimation(currwdg, nextwdg, move);

    ui->lineedit_num->clear();
    ui->lineedit_code->clear();
    ui->lineedit_num_refund->clear();
    ui->lineedit_code_refund->clear();

}

void FMPPayDialog::showErrorMsg(QString errormsg)
{
    ui->lineedit_code->clear();

    if(errormsg == "")
        errormsg = QString("");

    _wait->SetContent(FMPPayWait::ERRORS, errormsg);

    if(_wait->isHidden())
        _wait->show();
}

void FMPPayDialog::showSuccessMsg(QJsonObject json)
{
    ui->lineedit_num->clear();
    ui->lineedit_code->clear();
    ui->lineedit_num_refund->clear();
    ui->lineedit_code_refund->clear();

    if(!_wait->isHidden())
        _wait->hide();

    if(ui->btn_pay->isChecked())
        setPaySuccessView(json);
    else
        setRefundSuccessView(json);
}
void FMPPayDialog::setBasicInfo(QVariantHash basicinfo)
{
    QString date = basicinfo[FMP_BASIC_BUSINESSDATE].toString();
    ui->label_date->setText(date);
}

FMPPayDialog::~FMPPayDialog()
{
    if(_wnd_close_timer){
        if(_wnd_close_timer->isActive()){
            _wnd_close_timer->stop();
        }
        delete _wnd_close_timer;
    }

    if(_wait != NULL)
    {
        delete _wait;
    }

    delete ui;

//    if(_control != NULL)
//    {
//        delete _control;
//        _control = NULL;
//    }

}

void FMPPayDialog::onSelectionChanged(QModelIndex idx)
{
    if (ui->tableView->currentIndex() == idx) {
        ui->pushButton_2->setEnabled(true);
    }
    else {
        ui->pushButton_2->setEnabled(false);
    }
}

void FMPPayDialog::keyPressEvent(QKeyEvent *e)
{
    if (e->key() == Qt::Key_Escape) {
        emit ui->btn_close->click();
    }
}

void FMPPayDialog::mousePressEvent(QMouseEvent *event)
{
       _b_mouse_pressed = true;
       _mMovePosition = event->globalPos() - pos();
       return QDialog::mousePressEvent(event);
}

void FMPPayDialog::mouseMoveEvent(QMouseEvent *event)
{
    if (_b_mouse_pressed && (event->buttons() && Qt::LeftButton)
        && (event->globalPos()-_mMovePosition).manhattanLength() > QApplication::startDragDistance())
    {
        move(event->globalPos()-_mMovePosition);
        _mMovePosition = event->globalPos() - pos();
    }
    return QDialog::mouseMoveEvent(event);
}

void FMPPayDialog::mouseReleaseEvent(QMouseEvent *event)
{
    _b_mouse_pressed = false;
}

void FMPPayDialog::setPaySuccessView(QJsonObject json)
{
    ui->lb5->show();
    ui->tlb5->show();
    ui->lb6->show();
    ui->tlb6->show();

    ui->label_tip->setVisible(false);
    ui->verticalLayout->removeWidget(ui->label_tip);
    ui->wdg_right_bg->setMinimumHeight(450);

    ui->suc2->setText(QString::fromLocal8Bit("支付成功"));
    ui->tlb1->setText(QString::fromLocal8Bit("支 付 渠 道"));
    ui->lb1->setText(json[FMP_RPAY_PAY_RETURN_PAYID].toString());
    ui->tlb2->setText(QString::fromLocal8Bit("非码交易号"));
    ui->lb2->setText(json[FMP_EPAY_REFUND_TRANSTRACTION_FMID].toString());
    ui->tlb3->setText(QString::fromLocal8Bit("支付交易号"));
    ui->lb3->setText(json[FMP_RPAY_PAY_RETURN_TRANSID].toString());
    ui->tlb4->setText(QString::fromLocal8Bit("应 付 金 额"));
    ui->lb4->setText(QString::number(json[FMP_RPAY_PAY_RETURN_TOTAL].toDouble()/100));
    ui->tlb5->setText(QString::fromLocal8Bit("优 惠 金 额"));
    ui->lb5->setText(QString::number(json[FMP_RPAY_PAY_RETURN_MCUPON].toDouble()/100));
    ui->tlb6->setText(QString::fromLocal8Bit("实 付 金 额"));
    ui->lb6->setText(QString::number(json[FMP_RPAY_PAY_RETURN_ALIPAY].toDouble()/100));

    _success_flag = true;

    PlayAnimation(findChild<QWidget *>(_curt_btn->property("pageName").toString()), ui->wdg_success_main, RightToLeft);

    ui->btn_success_confirm->setFocus();
    _wnd_close_timer->start(1000);
}

void FMPPayDialog::setRefundSuccessView(QJsonObject json)
{
    ui->label_tip->setVisible(false);
    ui->verticalLayout->removeWidget(ui->label_tip);
    ui->wdg_right_bg->setMinimumHeight(450);

    ui->suc2->setText(QString::fromLocal8Bit("退款成功"));
    ui->tlb1->setText(QString::fromLocal8Bit("支 付 渠 道"));
    ui->lb1->setText(json[SQL_KEY_PAYID].toString());
    ui->tlb2->setText(QString::fromLocal8Bit("非码交易号"));
    ui->lb2->setText(json[SQL_KEY_FMID].toString());
    ui->tlb3->setText(QString::fromLocal8Bit("支付交易号"));
    ui->lb3->setText(json[SQL_KEY_PAYTRANSID].toString());
    ui->tlb4->setText(QString::fromLocal8Bit("退 款 金 额"));
    ui->lb4->setText(QString::number(json[SQL_KEY_TOTALAMOUNT].toDouble() / 100));
    ui->lb5->hide();
    ui->tlb5->hide();
    ui->lb6->hide();
    ui->tlb6->hide();

    _success_flag = true;

    PlayAnimation(findChild<QWidget *>(_curt_btn->property("pageName").toString()), ui->wdg_success_main, RightToLeft);

    ui->btn_success_confirm->setFocus();
    _wnd_close_timer->start(1000);
}

void FMPPayDialog::setPayView()
{
    ui->label_tip->setVisible(true);
    ui->lineedit_num->setFocus();
    ui->btn_pay->setChecked(true);
    ui->btn_refund->setChecked(false);
    ui->btn_check->setChecked(false);
    _current_LineEdit = ui->lineedit_num;
}

void FMPPayDialog::setRefundView()
{
    ui->label_tip->setVisible(true);
    ui->btn_pay->setChecked(false);
    ui->btn_refund->setChecked(true);
    ui->btn_check->setChecked(false);
    ui->lineedit_num_refund->setFocus();
    _current_LineEdit = ui->lineedit_num_refund;
}

void FMPPayDialog::setCheckView()
{
    ui->label_tip->setVisible(false);
    ui->pushButton_2->setEnabled(false);

    ui->btn_pay->setChecked(false);
    ui->btn_refund->setChecked(false);
    ui->btn_check->setChecked(true);

    ui->lineEdit->clear();
    _control->GetMode();
}

void FMPPayDialog::onBtnNumClicked()
{
    QString num_str = qobject_cast<QPushButton*>(sender())->text();

    if((_current_LineEdit == ui->lineedit_num && CheckLineEditSum(_current_LineEdit->text().append(num_str))) ||
    (_current_LineEdit == ui->lineedit_num_refund && CheckLineEditSum(_current_LineEdit->text().append(num_str))))
    {
        _current_LineEdit->setText(_current_LineEdit->text().append(num_str));
    }

    if((_current_LineEdit == ui->lineedit_code && CheckLineEditCode(_current_LineEdit->text().append(num_str))) ||
        (_current_LineEdit == ui->lineedit_code_refund && CheckLineEditCode(_current_LineEdit->text().append(num_str)))    )
    {
        _current_LineEdit->setText(_current_LineEdit->text().append(num_str));
    }
}


bool FMPPayDialog::CheckLineEditSum(QString sum)
{

    if(sum.compare("0.00") == 0 || sum.compare("00") == 0)
        return false;

    if(sum.contains("."))
    {
        QStringList list = sum.split(".");

        if(list.size() == 2)
        {
            QString tmp = list.value(1);
            if(tmp.size() > 2)
                return  false;
        }else
            return false;
    }

    return true;
}

bool FMPPayDialog::CheckLineEditCode(QString code)
{
    int i = 0;

    while( i < code.size())
    {

        if(!((code[i] >= 'a' && code[i] <= 'z') || (code[i] >= 'A' && code[i] <= 'Z') || (code[i] >= '0' && code[i] <= '9')))
            break;
        ++i;
    }

    return (i == code.size());
}

void FMPPayDialog::PlayAnimation(QWidget *target0, QWidget *target1, Movemode movemode)
{
    if(_is_amt)
    {
        return ;
    }

    _is_amt = true;

    //! WARNING: 需要注意是否所有的页面都要设置为不可用
//    ui->btn_pay->setEnabled(false);
//    ui->btn_refund->setEnabled(false);
//    ui->btn_check->setEnabled(false);

    int tg0_begin_x = 0, tg0_begin_y = 0;
    int tg0_end_x = 0, tg0_end_y = 0;
    int tg1_begin_x = 0, tg1_begin_y = 0;
    int tg1_end_x  = 0, tg1_end_y = 0;

    switch (movemode) {
    case TopToBtm:

        tg0_begin_x = 0, tg0_begin_y = 0;
        tg0_end_x = 0, tg0_end_y = target0->height();
        tg1_begin_x = 0, tg1_begin_y = -target1->height();
        tg1_end_x  = 0, tg1_end_y = 0;
        break;
    case BtmToTop:
        tg0_begin_x = 0, tg0_begin_y = 0;
        tg0_end_x = 0, tg0_end_y = -target0->height();
        tg1_begin_x = 0, tg1_begin_y = target1->height();
        tg1_end_x  = 0, tg1_end_y = 0;
        break;
    case LeftToRight:
        tg0_begin_x = 0, tg0_begin_y = 0;
        tg0_end_x = target0->width(), tg0_end_y = 0;
        tg1_begin_x = -target1->width(), tg1_begin_y = 0;
        tg1_end_x  = 0, tg1_end_y = 0;
        break;
    case RightToLeft:

        tg0_begin_x = 0, tg0_begin_y = 0;
        tg0_end_x = -target0->width(), tg0_end_y = 0;
        tg1_begin_x = target1->width(), tg1_begin_y = 0;
        tg1_end_x  = 0, tg1_end_y = 0;
        break;
    default:
        tg0_begin_x = 0, tg0_begin_y = 0;
        tg0_end_x = 0, tg0_end_y = target0->height();
        tg1_begin_x = 0, tg1_begin_y = -target1->height();
        tg1_end_x  = 0, tg1_end_y = 0;
        break;
    }

    target0->move(tg0_end_x, tg0_end_y);
    target1->move(tg1_end_x, tg1_end_y);

    if(_needanimation)
    {
        QPropertyAnimation animation0, animation1;
        QEventLoop loop;

        connect(&animation0, &QPropertyAnimation::finished, &loop, &QEventLoop::quit);

        animation0.setTargetObject(target0);
        animation0.setPropertyName("pos");
        animation0.setDuration(382);
        animation0.setEasingCurve(QEasingCurve::OutBack);
        animation0.setStartValue(QPoint(tg0_begin_x, tg0_begin_y));
        animation0.setEndValue(QPoint(tg0_end_x, tg0_end_y));

        animation1.setTargetObject(target1);
        animation1.setPropertyName("pos");
        animation1.setDuration(382);
        animation1.setEasingCurve(QEasingCurve::OutBack);
        animation1.setStartValue(QPoint(tg1_begin_x, tg1_begin_y));
        animation1.setEndValue(QPoint(tg1_end_x, tg1_end_y));
        animation0.start();
        animation1.start();

        loop.exec();
    }

    _is_amt = false;

    //! WARNING: 需要注意是否所有的页面都要重新设置为可用，有些页面可能一开始就不可用，但此处会将其设置为可用
//    ui->btn_pay->setEnabled(true);
//    ui->btn_refund->setEnabled(true);
//    ui->btn_check->setEnabled(true);
}

//确定按钮
void FMPPayDialog::onBtnConfirmClicked()
{
    if(_wait == NULL)
    {
        _wait = new FMPPayWait(this);
        _wait->setModal(true);
        _wait->setFocus();
    }

    if(_isConfirmRefund) {
        _isConfirmRefund = false;
    } else {
        if((ui->lineedit_num->text() == "" && ui->lineedit_num_refund->text() == "") ||
           (ui->lineedit_num->text().toDouble() < 0.01  && ui->lineedit_num_refund->text().toDouble() < 0.01)||
           (ui->lineedit_code->text() == "" && ui->lineedit_code_refund->text() == "") ||
           (ui->lineedit_code->text().size() < 15 && ui->lineedit_code_refund->text().size() < 15)
                )
        {
    //        if (!_is_api) {
    //            ui->lineedit_num->clear();
    //            ui->lineedit_num_refund->clear();
    //        }
            ui->lineedit_code->clear();
            ui->lineedit_code_refund->clear();
            _wait->SetContent(FMPPayWait::ERRORS, QString::fromLocal8Bit("金额或条码错误\n请重新输入"));
            _wait->show();
            _current_LineEdit->setFocus();
            return;
        }
    }


    if(ui->btn_pay->isChecked())
    {
        _wait->SetContent(FMPPayWait::LOADING, QString::fromLocal8Bit("支付中..."));
        _control->ControlPayJson(ui->lineedit_num->text(), ui->lineedit_code->text());

    }
    else
    {
        _wait->SetContent(FMPPayWait::LOADING, QString::fromLocal8Bit("退款中..."));
        QJsonObject trans;
        trans["refund_amount"] = (int)((ui->lineedit_num_refund->text().toDouble() + 0.005) * 100);
        trans["fm_id"] = ui->lineedit_code_refund->text();
        _control->ControlRefundJson(trans);
    }

    _wait->show();
    _current_LineEdit->setFocus();
}


void FMPPayDialog::on_btn_backspace_clicked()
{
    _current_LineEdit->setText(_current_LineEdit->text().left(_current_LineEdit->text().length() - 1));
}

void FMPPayDialog::on_btn_clear_clicked()
{
    if (_current_LineEdit) {
        _current_LineEdit->clear();
    }
}

void FMPPayDialog::reject()
{
    on_btn_close_clicked();
}

void FMPPayDialog::on_btn_close_clicked()
{
    this->hide();
}

void FMPPayDialog::onLineeditCodeGetFocus()
{
    _current_LineEdit = (FMPFocusLineEdit *) sender();

    if (ui->lineedit_num == _current_LineEdit) {
        ui->label_tip->setText(QString::fromLocal8Bit("请输入支付金额"));
    }
    else if (ui->lineedit_code == _current_LineEdit) {
        ui->label_tip->setText(QString::fromLocal8Bit("请扫描或输入条码"));
    }
    else if (ui->lineedit_num_refund == _current_LineEdit) {
        ui->label_tip->setText(QString::fromLocal8Bit("请输入退款金额"));
    }
    else if (ui->lineedit_code_refund == _current_LineEdit) {
        ui->label_tip->setText(QString::fromLocal8Bit("请扫描或输入退款码"));
    }
}

void FMPPayDialog::on_btn_success_confirm_clicked()
{
    if(_is_amt)
    {
        return ;
    }

    if(_curt_btn->property("index").toInt() == 0)
        setPayView();

    if(_curt_btn->property("index").toInt() == 1)
        setRefundView();

    if(_curt_btn->property("index").toInt() == 2)
        setCheckView();

    _success_flag = false;

    QWidget *nextwdg = findChild<QWidget *>(_curt_btn->property("pageName").toString());
    PlayAnimation(ui->wdg_success_main, nextwdg, LeftToRight);

    on_btn_close_clicked();

    //! 退出事件循环
    _control->OnFinish();
}

void FMPPayDialog::on_btn_paycheck_clicked()
{
    _control->GetCheckMode(ui->lineEdit->text());
}

void FMPPayDialog::on_pushButton_2_clicked()
{

    if(_wait == NULL)
    {
        _wait = new FMPPayWait(this);
        _wait->setModal(true);
    }


    QSqlTableModel *model = qobject_cast<QSqlTableModel*>(ui->tableView->model());
    QModelIndex idx = ui->tableView->currentIndex();

    _wait->SetContent(FMPPayWait::LOADING, QString::fromLocal8Bit("退款中..."));
    QJsonObject trans;
    trans["refund_amount"] = (int)(model->data(idx.sibling(idx.row(), 6)).toDouble() + 0.005) * 100;
    trans["fm_id"] = model->data(idx.sibling(idx.row(),0)).toString();
    _control->ControlRefundJson(trans);

    _wait->show();
}

void FMPPayDialog::on_btn_clear_refund_clicked()
{
    if (_current_LineEdit) {
        _current_LineEdit->clear();
    }
}

void FMPPayDialog::on_btn_backspace_refund_clicked()
{
    _current_LineEdit->setText(_current_LineEdit->text().left(_current_LineEdit->text().length() - 1));
}

void FMPPayDialog::on_lineEdit_textChanged(const QString &arg1)
{
    _control->GetCheckMode(arg1);
    ui->pushButton_2->setEnabled(false);
}

void FMPPayDialog::timerHandle()
{
    QString btnText=QString::fromLocal8Bit("确定(");
    btnText+=QString::number(_seconds);
    btnText+=")";
    ui->btn_success_confirm->setText(btnText);

    if(_seconds <=0 && _wnd_close_timer->isActive()){
        _wnd_close_timer->stop();
        on_btn_success_confirm_clicked();
    }
    _seconds--;
}
