﻿#ifndef FMP_EPAY_P_H
#define FMP_EPAY_P_H

#include "fmp_epay.h"
#include <QObject>
#include <QFuture>
#include <QFutureWatcher>
#include <QJsonObject>
#include <QEventLoop>

class FMPPayDialog;
class FMPSettingsInterface;
class FMPLoggerInterface;
class FMPNetworkInterface;
class FMPDataBase;
class QSqlTableModel;

class FMPePayPrivate : public QObject
{
    Q_OBJECT
    Q_DECLARE_PUBLIC(FMPePay)
public:
    explicit            FMPePayPrivate(FMPePay* parent);
    ~FMPePayPrivate();

    void                Uninit();

    void                Init();

    void                ControlPayJson(QString sum, QString code);

    void                ControlRefundJson(const QJsonObject &trans);

    void                GetCheckMode(QString sum);

    void                GetMode();

    QSqlTableModel      *model() const;

    void                DockPayRequest(const QByteArray &json);
    QByteArray          DockPayRespond();

    void                DockRefundRequest(const QByteArray &json);
    QByteArray          DockRefundRespond();
    
    void                DockQueryRequest(const QByteArray &json);
    QByteArray          DockQueryRespond();


private:
    void                ControlReverseJson();

    bool                GetRefundJson(const QJsonObject &trans);

    void                GetReverseJson();

    bool                GetPayJson(const QString &sum, const QString &code);

    bool                HttpPost(QJsonObject& outjson, QJsonObject json, QString &error, int timeout = 60);

    bool                CheckReturnJson(QByteArray data, QJsonObject &returnjson);

    void                SetBasicInfo(QVariantHash hash);

    void                clearorder();

signals:
    void                confirmClicked();
    void                apiError();
    void                error(QString errormsg);

    void                finished(QJsonObject json);

public slots:
    void                OnFinish();

protected slots:
    void                witedata();
public:

    FMPePay            *q_ptr;

    FMPPayDialog       *_payDialog;

    FMPSettingsInterface *_setting;

    int auto_close_seconds;   //支付成功后自动关闭窗口秒数
private:
    QJsonObject         _origin_request;
    QJsonObject         _docked_request;
    QJsonObject         _origin_response;
    QJsonObject         _docked_response;
    QEventLoop          _api_evt;
    bool                _is_api;
    bool                _api_abort;
    bool                _reverse_flag;

    static unsigned int s_ClientReqCount;

    FMPDataBase *_db;

    QSqlTableModel *_model;

    QFutureWatcher<QByteArray> *_watcher;

    void HttpPost(const QString &url, const QByteArray &data, QFutureWatcher<QByteArray> *furture, int timeout = 10);

};

#endif // FMP_EPAY_P_H
