#include "fmp_payfailed_dialog.h"
#include "ui_fmp_payfailed_dialog.h"

FMPPayFailedDialog::FMPPayFailedDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::FMPPayFailedDialog)
{
    ui->setupUi(this);
    setWindowFlags(Qt::FramelessWindowHint | windowFlags());
    this->setAttribute(Qt::WA_DeleteOnClose);
    connect(this, SIGNAL(cash_pay()), parent, SLOT(on_cash_pay()));
}

FMPPayFailedDialog::~FMPPayFailedDialog()
{
    delete ui;
}

void FMPPayFailedDialog::on_pushButton_retry_clicked()
{
    close();
}

void FMPPayFailedDialog::on_pushButton_cash_clicked()
{
    FMPCashConfirmDialog *_CashConfirm=new FMPCashConfirmDialog(this);
    _CashConfirm->setModal(true);

    _CashConfirm->show();
    _CashConfirm->SetContent(_money);
}

void FMPPayFailedDialog::on_cash_cancel()
{
    this->close();
}

void FMPPayFailedDialog::on_cash_pay()
{
    emit cash_pay();
}

void FMPPayFailedDialog::SetContent(const QString& msg,const QString& money)
{
    _money=money;
    ui->label_warn->setText(QString("本次支付没有成功[%1]").arg(msg));
}
