﻿#ifndef DIALOG_H
#define DIALOG_H

#include <QJsonObject>
#include <QJsonArray>
#include <QVariantHash>
#include <QJsonDocument>
#include <QModelIndex>
#include <QDateTime>
#include <QTimer>

#include <QDialog>
#include <QLineEdit>
#include "fmp_epayview_wait.h"
#include "fmp_epayview_focuslineedit.h"
#include "fmp_payfailed_dialog.h"

#define DIALOG_FORCE_CLOSE 1   //窗口强制关闭
#define DIALOG_CASH_CLOSE  2   //转现金支付

#define ORDER_NEED_PAY     1   //待支付订单
#define ORDER_HAS_ERROR    2   //支付失败订单
#define ORDER_PAY_SUCCESS  3   //支付成功订单
#define ORDER_DONE         4   //已关闭订单

class FMPePayPrivate;
class FMPLoggerInterface;

namespace Ui {
class FMPPayDialog;
}

class FMPPayDialog : public QDialog
{
    Q_OBJECT

typedef enum
{
    TopToBtm = 0,
    BtmToTop,
    LeftToRight,
    RightToLeft
} Movemode;

public:
    explicit FMPPayDialog(FMPePayPrivate *control, QVariantHash basicinfo, QWidget *parent = 0);

    void show();

    ~FMPPayDialog();

public slots:
    void showErrorMsg(QString errormsg);

    void showSuccessMsg(QJsonObject json);

    void onSelectionChanged(QModelIndex idx);

    void onWaitPaySelectionChanged(QModelIndex idx);

    void setBasicInfo(QVariantHash basicinfo);

    void on_cash_pay();
	void on_force_close();
protected:
    void keyPressEvent(QKeyEvent *);

    void mousePressEvent(QMouseEvent *);
    void mouseMoveEvent(QMouseEvent *);
    void mouseReleaseEvent(QMouseEvent *);

private slots:
    void onWidgetChange();

    void onBtnNumClicked();

    void onBtnConfirmClicked();

    void on_btn_backspace_clicked();

    void on_btn_clear_clicked();

    void on_btn_close_clicked();

    void onLineeditCodeGetFocus();

    void on_btn_success_confirm_clicked();

    void on_btn_paycheck_clicked();

    void on_pushButton_2_clicked();

    void on_btn_clear_refund_clicked();

    void on_btn_backspace_refund_clicked();

    void on_lineEdit_textChanged(const QString &arg1);

    void on_btn_waitPay_pay_clicked();

    void on_btn_waitPay_close_clicked();

public:
    void setPayView();

    void setRefundView();

    void setShowFunc();

private:

    void setCheckView();

    void setPaySuccessView(QJsonObject json);

    void setRefundSuccessView(QJsonObject json);

    bool CheckLineEditSum(QString sum);

    bool CheckLineEditCode(QString code);

    //-----------
    void PlayAnimation(QWidget* target0, QWidget* target1, Movemode movemode);

    void closeEvent(QCloseEvent * event);

    void setTableHeader();
    void setSuccessView();
    void setErrorOrderView();
    void setWaitPayView();
    void setDoneView();

private:
    Ui::FMPPayDialog *ui;

    FMPFocusLineEdit *_current_LineEdit;

    FMPePayPrivate *_control;

    FMPPayWait *_wait;

    //----------
    QPushButton* _curt_btn;

    bool _success_flag;
    bool _is_amt;
    bool _needanimation;
    bool _b_mouse_pressed;
    bool _is_api;
    bool _api_force_close;
    QPoint      _mMovePosition;
};

#endif // DIALOG_H
