﻿#ifndef FMP_EPAY_P_H
#define FMP_EPAY_P_H

#include "fmp_epay.h"
#include "cquerythread.h"
#include <QObject>
#include <QFuture>
#include <QJsonObject>

class FMPPayDialog;
class FMPSettingsInterface;
class FMPLoggerInterface;
class FMPNetworkInterface;
class FMPDataBase;
class QSqlTableModel;
class CQueryThread;

typedef struct {
    int flag;
    int ver;
    int len;
}FMSOCKEHEADER;

class FMPePayPrivate : public QObject
{
    Q_OBJECT
    Q_DECLARE_PUBLIC(FMPePay)
public:
    explicit            FMPePayPrivate(FMPePay* parent);
    ~FMPePayPrivate();

    void                Uninit();

    void                Init();

    void                ControlPayJson(QString sum, QString code);

    void                ControlRefundJson(const QJsonObject &trans);

    void                GetCheckMode(QString sum);

    void                GetMode();

    void                GetApiReqMode(int type);

    void                ClosePayWindow(int type);
    QSqlTableModel      *model() const;

    void                DockPayRequest(const QByteArray &json);
    QByteArray          DockPayRespond();

    void                DockRefundRequest(const QByteArray &json);
    QByteArray          DockRefundRespond();

    void                writeOrderToSqlite();

    void                updateSqlite(const QJsonObject &json);

    void                setPosTransId(QString orderId);

    bool                HttpPost(QJsonObject& outjson, QJsonObject json, QString &error, int timeout = 60);

private:
    void                ControlReverseJson();

    bool                GetRefundJson(const QJsonObject &trans);

    void                GetReverseJson();

    bool                GetPayJson(const QString &sum, const QString &code);  

    bool                CheckReturnJson(QByteArray data, QJsonObject &returnjson);

    void                SetBasicInfo(QVariantHash hash);

    void                clearorder();

    bool                SendToMonitor(const QByteArray &data);

    void                HttpPost(const QString &url, const QByteArray &data, QFutureWatcher<QByteArray> *furture, int timeout = 10);

    void                CheckErrorOrder();   //查询异常订单，如果有异常订单，则进入查询状态

signals:
    void                apiError();
    void                apiFinish();
    void                error(QString errormsg);

    void                finished(QJsonObject json);

protected slots:
    void                witedata();
public:

    FMPePay            *q_ptr;

    FMPPayDialog       *_payDialog;

    FMPSettingsInterface *_setting;

    FMPNetworkInterface *_network;
    bool                _is_api;
    CQueryThread        *_queryThread;
private:
    bool                _reverse_flag;

    static unsigned int s_ClientReqCount;

    FMPDataBase *_db;

    QSqlTableModel *_model;

    QFutureWatcher<QByteArray> *_watcher;
    QJsonObject         _origin_request;
    QJsonObject         _docked_request;
    QJsonObject         _origin_response;
    QJsonObject         _docked_response;

    QString             _pos_trans_id;
};

#endif // FMP_EPAY_P_H
