﻿#ifndef FMPT_H
#define FMPT_H

#include <QSqlTableModel>
#include <QStyledItemDelegate>

class FMPPayCheckModel : public QSqlTableModel
{
public:
    explicit        FMPPayCheckModel(QObject *parent, QSqlDatabase db)  : QSqlTableModel(parent, db)
    {

    }

    QVariant        data(const QModelIndex &idx, int role = Qt::DisplayRole) const
    {
        if (idx.column() == 6 && role == Qt::DisplayRole) {
            QVariant d = QSqlTableModel::data(idx,role);
            return d.toString().toFloat() / 100;
        }

        if ((idx.column() == 12) && role == Qt::DisplayRole) {
            QVariant d = QSqlTableModel::data(idx,role);
            if (d.toBool()) {
                return QString::fromLocal8Bit("已退款");
            }
            else
            {
                return QString::fromLocal8Bit("未退款");
            }
        }
        if ((idx.column() == 14) && role == Qt::DisplayRole) {
            QVariant d = QSqlTableModel::data(idx,role);
            if (d.toInt()==100) {
                return QString::fromLocal8Bit("成功");
            }
            else if(d.toInt()==102)
            {
                return QString::fromLocal8Bit("超时");
            }
            else if(d.toInt()==105||d.toInt()==106)
            {
                return QString::fromLocal8Bit("待支付");
            }
            else if(d.toInt()==108)
            {
                return QString::fromLocal8Bit("关闭");
            }
        }

        return QSqlTableModel::data(idx, role);
    }
};

class FMPPayItemDelegate : public QStyledItemDelegate
{
    Q_OBJECT
public:
    explicit        FMPPayItemDelegate()
    {

    }

    void            paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
    {
        QStyledItemDelegate::paint(painter, option, index);
    }


//    QWidget *       createEditor(QWidget *parent,
//                                 const QStyleOptionViewItem &option,
//                                 const QModelIndex &index) const Q_DECL_OVERRIDE
//    {
//        return 0;
//    }

    QSize           sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const
    {
        return QStyledItemDelegate::sizeHint(option, index);
    }

};

#endif // FMPT_H
