#include "fmp_database.h"

#include <QDebug>
#include <QSqlError>
#include <QSqlQuery>
#include <QVariantHash>
#include <QSqlQueryModel>
#include <fmp_logger_i.h>

FMPDataBase::FMPDataBase(QString dbname, QString connectname, QObject *parent) : QObject(parent)
{
    _db = QSqlDatabase::addDatabase("QSQLITE", connectname);
    _db.setDatabaseName(dbname);   
    _isopen = _db.open();
}

FMPDataBase::~FMPDataBase()
{
    if(_isopen)
        _db.close();
}

bool FMPDataBase::creat(QString sql)
{
    if(!_isopen)
        return false;

    QSqlQuery query(_db);

    bool flag = query.exec(sql);

    if(!flag)
        FMP_WARN() << query.lastError();

    return flag;
}

bool FMPDataBase::dlt(QString table, QString condition)
{
    if(!_isopen)
        return false;

    QString sql = QString("delete from %1 where %2").arg(table, condition);

    QSqlQuery query(_db);

    bool flag =  query.exec(sql);

    if(!flag)
        FMP_WARN() << query.lastError();

    return flag;
}

bool FMPDataBase::insert(QString table, QVariantHash data)
{
    if(!_isopen)
        return false;

    QString sql;
    QStringList columnnamelist;
    QStringList columnvaluelist;

    if(!getSql(table, data, columnnamelist, columnvaluelist))
    {
        _db.close();
        return false;
    }

    QSqlQuery query(_db);

    sql = QString("insert into %1 (").arg(table) + columnnamelist.join(", ") + ") values (" + columnvaluelist.join(", ") + ")";

    FMP_INFO() << "inset sql : " << sql;
    qDebug() << "inset sql : " << sql;


    bool flag =  query.exec(sql);

    if(!flag)
        FMP_WARN() << query.lastError();

    return flag;
}

bool FMPDataBase::update(QString table, QVariantHash data, QString condition)
{
    if(!_isopen)
        return false;

    QString sql;

    if(!getSql(table, data, sql))
    {
         _db.close();
        return false;
    }

    QSqlQuery query(_db);

    sql = QString("update %1 set ").arg(table) + sql + " where " + condition;

    FMP_INFO() << "update sql : " << sql;

    bool flag =  query.exec(sql);

    if(!flag)
        FMP_WARN() << query.lastError();

    return flag;
}

bool FMPDataBase::find(QString table, QSqlQuery &query, QStringList keylist, QString condition)
{
    if(!_isopen)
        return false;

    QSqlQuery tmpquery(_db);

    QString sql = "select ";
    if(keylist.size() != 0)
        sql += keylist.join(", ");
    else
        sql += "*";

    if(condition == "")
        condition = "1=1";

    sql += QString(" from %1 where ").arg(table) + condition;

    FMP_INFO() << "find sql : " << sql;

    bool flag =  tmpquery.exec(sql);

    if(!flag)
        FMP_WARN() << tmpquery.lastError();

    query = tmpquery;

    return flag;
}

bool FMPDataBase::isRecordExist(QString table, QString condition)
{
    if(!_isopen)
        return false;
    QSqlQuery tmpquery(_db);
    QString sql = QString("select * from %1 where trans_id = '%2'").arg(table, condition);
    //QString sql = QString("select * from %1 where trans_id = '%2'").arg(table, "70102003004005");
    FMP_INFO() << "find sql : " << sql;

    bool flag =  tmpquery.exec(sql);

    if(!flag)
        FMP_WARN() << tmpquery.lastError();

    tmpquery.last();
    int total=tmpquery.at()+1;

    if(total>0)
        return true;
    return false;
}

bool FMPDataBase::getSql(QString table, QVariantHash data, QStringList& columnnamelist, QStringList& columnvaluelist)
{
    QSqlQuery query(_db);

    QString tmpsql = QString("PRAGMA table_info(%1)").arg(table);
    query.exec(tmpsql);

    while(query.next())
    {
        QString columnname = query.value(1).toString();

        if(data.contains(columnname))
        {
            /**
              *add support type;
              * */
//            switch (data.value(columnname).type()) {
//            case QVariant::Int:
//                columnnamelist.append(columnname);
//                columnvaluelist.append(QString("'") + QString::number(data.value(columnname).toInt()) + "'");
//                break;
//            case QVariant::String:
//                columnnamelist.append(columnname);
//                columnvaluelist.append(QString("'") + data.value(columnname).toString() + "'");
//                break;
//            case QVariant::Bool:
//                columnnamelist.append(columnname);
//                columnvaluelist.append(QString("'") + QString::number(data.value(columnname).toBool()? 1 : 0) + "'");
//                break;
//            default:
//                break;
//            }

              columnnamelist.append(columnname);
              columnvaluelist.append(QString("'") + data.value(columnname).toString() + "'");

        }
        continue ;
    }


    if(columnnamelist.size() == 0)
        return false;
    return true;
}

QSqlDatabase FMPDataBase::getDb() const
{
    return _db;
}

bool FMPDataBase::getSql(QString table, QVariantHash data, QString& sql)
{
    QSqlQuery query(_db);

    QString tmpsql = QString("PRAGMA table_info(%1)").arg(table);
    query.exec(tmpsql);

    QStringList list;

    while(query.next())
    {
        QString columnname = query.value(1).toString();

        if(data.contains(columnname))
        {
            /**
              *add support type(mysql/sqlserver/...);
              * */
//            switch (data.value(columnname).type()) {
//            case QVariant::Int:
//                list.append(columnname + " = '" + QString::number(data.value(columnname).toInt()) + "'");
//                break;
//            case QVariant::String:
//                list.append(columnname + " = '" + data.value(columnname).toString() + "'");
//                break;
//            case QVariant::Bool:
//                list.append(columnname + " = '" + QString::number(data.value(columnname).toBool()? 1 : 0) + "'");
//                break;
//            default:
//                break;
//            }
            /**
             * sqlite
             * */
            list.append(columnname + " = '" + data.value(columnname).toString() + "'");
        }
        continue ;
    }


    if(list.size() == 0)
        return false;

    sql = list.join(", ");

    return true;
}
