#include "fmp_cashconfirm_dialog.h"
#include "ui_fmp_cashconfirm_dialog.h"

FMPCashConfirmDialog::FMPCashConfirmDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::FMPCashConfirmDialog)
{
    ui->setupUi(this);
    setWindowFlags(Qt::FramelessWindowHint | windowFlags());

    this->setAttribute(Qt::WA_DeleteOnClose);
    connect(ui->pushButton_cancel, SIGNAL(clicked()), parent, SLOT(on_cash_cancel()));
    connect(ui->pushButton_ok, SIGNAL(clicked()), parent, SLOT(on_cash_pay()));

}

FMPCashConfirmDialog::~FMPCashConfirmDialog()
{
    delete ui;
}

void FMPCashConfirmDialog::on_pushButton_cancel_clicked()
{
    this->close();
}

void FMPCashConfirmDialog::SetContent(const QString& money)
{
    ui->label_money->setText(QString("%1").arg(money));
}
