﻿#include <QDebug>
#include <QDateTime>
#include <fmp_settings_i.h>
#include <QCoreApplication>
#include <ctkPluginContext.h>
#include <ctkServiceReference.h>
#include "fmp_epay_p.h"
#include "fmp_epay_def.h"
#include "fmp_logger_i.h"
#include "fmp_pe_handlers.h"
#include "fmp_epayview_dialog.h"
#include "fmp_network_i.h"
#include "fmp_database.h"
#include "fmp_epay_checkmodel.h"

#include <QSslCertificate>
#include <QJsonParseError>
#include <QJsonDocument>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QtConcurrent>
#include <QTimer>
#include <QFuture>

#include <QSqlQuery>

#include <fmp_home_i.h>


unsigned int FMPePayPrivate::s_ClientReqCount = 10000;

FMPePayPrivate::FMPePayPrivate(FMPePay *parent)
    : q_ptr(parent),
      _payDialog(nullptr),
      _setting(nullptr),
      _network(nullptr),
      _model(nullptr),
      _db(nullptr),
      _watcher(nullptr),
      _reverse_flag(false)
{
    FMPLoggerInterface::InitContext(q_ptr->_ctx);
    _watcher = new QFutureWatcher<QByteArray>();
    connect( _watcher, SIGNAL( finished() ), this, SLOT( witedata() ) );
}

FMPePayPrivate::~FMPePayPrivate()
{   
    if(_watcher != nullptr){
        delete _watcher;
    }

    if(_payDialog != nullptr) {
        delete _payDialog;
    }

    if(_model != nullptr){
        delete _model;
    }

    if(_db != nullptr){
        delete _db;
    }
}

void FMPePayPrivate::Uninit()
{
    Q_Q(FMPePay);
    q->_inited = false;

    if(_watcher != nullptr){
        delete _watcher;
        _watcher = nullptr;
    }

    if(_payDialog != nullptr) {
        delete _payDialog;
        _payDialog = nullptr;
    }

    if(_model != nullptr){
        delete _model;
        _model = nullptr;
    }

    if(_db != nullptr){
        delete _db;
        _db = nullptr;
    }
}

void FMPePayPrivate::Init()
{
    Q_Q(FMPePay);
    q->_inited = true;

    clearorder();

    if(_network == nullptr)
    {
        _network = q->GetService<FMPNetworkInterface>(q->_ctx);
    }

    if(_db == nullptr)
    {
        _db = new FMPDataBase(q->_databasename);

        QString sql = "create table " + q->_table + " ("
                      "fmId varchar(40) primary key, "
                      "code varchar(40), "
                      "pay_transId varchar(40), "
                      "trans_id varchar(40),"
                      "pay_id varchar(40), "
                      "pay_ebcode varchar(20), "
                      "total_amount integer, "
                      "pcoupon_amount integer, "
                      "mcoupon_amount integer, "
                      "alipay_amount integer, "
                      "invoice_amount integer, "
                      "business_date date, "
                      "isrefund boolean, "
                      "refund_date date"
                      ")";

        FMP_INFO() << " creat table sql:" << sql;

        if(_db->creat(sql))
        {
            FMP_WARN() << "creat table fmp_pay failed";
        }
    }

    if(_model == nullptr)
    {
        _model = new FMPPayCheckModel(NULL, _db->getDb());
        _model->setTable(q->_table);
        _model->setEditStrategy(QSqlTableModel::OnManualSubmit);
    }

    if(_payDialog == nullptr) {

        QVariantHash hash;

        _setting = q->GetService<FMPSettingsInterface>(q->_ctx);

        q->_url = _setting->GetString(FMP_INIKEY_EPAYURL);
        q->_store_id = _setting->GetString(FMP_INIKEY_LOGINSTOREID);
        q->_station_id = _setting->GetString(FMP_INIKEY_LOGINPOSID);
        q->_operator_id = _setting->GetString(FMP_INIKEY_LOGINCASHIER);
        q->_partner_id = _setting->GetString(FMP_INIKEY_LOGINPARTNERID);
        q->_time_out = _setting->GetInt(FMP_INIKEY_EPAYTIMEOUT);

        q->_time_out = (q->_time_out > 60 ? q->_time_out : 60);

        hash[FMP_EPAY_ANIMATION] = _setting->GetBool(FMP_INIKEY_ANIMATION);
        hash[FMP_EPAY_BUSINESSDATE] = q->_businessdate;
        hash[FMP_EPAY_STOREID] = q->_store_id;
        hash[FMP_EPAY_STATIONID] = q->_station_id;
        hash[FMP_EPAY_OPERATORID] = q->_operator_id;
        hash[FMP_EPAY_PARTNERID] = q->_partner_id;
        hash[FMP_EPAY_TIMEOUT] = q->_time_out;

        _payDialog = new FMPPayDialog(this, hash);
    }

    _payDialog->show();
}

void FMPePayPrivate::clearorder()
{
    Q_Q(FMPePay);

    QtConcurrent::run( [q, this]()
    {
        FMPDataBase db(q->_databasename, QString("fmp_pay_clean")) ;

        QDateTime date = QDateTime::currentDateTime();
        QDateTime tmpdate = date.addDays(-(q->_ordershelflife));
        QString deletedate = tmpdate.toString("yyyy-MM-dd");

        FMP_INFO() << "deletedate" <<deletedate;

        db.dlt(q->_table, QString(QString(SQL_KEY_BUSSINEDATE) + "<datetime('%1')").arg(deletedate));

    });
}

QSqlTableModel *FMPePayPrivate::model() const
{
    return _model;
}

void FMPePayPrivate::ControlPayJson(QString sum, QString code)
{
    Q_Q(FMPePay);


    QtConcurrent::run( [q, sum, code, this ]()
    {
        if(_reverse_flag)
        {
            emit error(QString::fromLocal8Bit("网络连接异常(冲正...)"));
            return ;
        }

        if(!GetPayJson(sum, code))
        {
            emit error(QString::fromLocal8Bit("获取门店信息失败"));
            return ;
        }

        FMP_INFO() << "pay json : " << _current_json;

        QString errors;
        QJsonObject outjson;

        if(!HttpPost(outjson, _current_json ,errors, q->_time_out))
        {
           emit error(errors);
        }
        else
        {
            outjson.insert(SQL_KEY_ISREFUND, false);
            outjson.insert(SQL_KEY_CODE, code);
            outjson.insert(SQL_KEY_BUSSINEDATE, q->_businessdate);
            outjson.insert(SQL_KEY_TRANSID, _current_json[SQL_KEY_TRANSID].toString());

            _db->insert(q->_table, outjson.toVariantHash());

            emit finished(outjson);
        }
    });
}

//void FMPePayPrivate::ControlPayJson(QString sum, QString code)
//{
//    Q_Q(FMPePay);

//    QByteArray data = "{ \"reqtype\" : 0}";

//    HttpPost(q->_url, data, _watcher);

//    qDebug() << "***********************" <<_watcher->future().result();
//}

void FMPePayPrivate::witedata()
{
    qDebug() << _watcher->future().result();
}

void FMPePayPrivate::HttpPost(const QString &url, const QByteArray &data, QFutureWatcher<QByteArray> *watcher, int timeout)
{
    QFuture<QByteArray> furture = QtConcurrent::run( [url, data, timeout, this]()->QByteArray
    {
        QEventLoop loop;
        QTimer timer;

        QNetworkAccessManager manger;
        QNetworkRequest request(url);

        request.setRawHeader("Content-Type","text/json");

        QNetworkReply* reply = manger.post(request, data);

        connect(&timer, &QTimer::timeout, &loop, &QEventLoop::quit);
        connect(&manger, &QNetworkAccessManager::finished, &loop, &QEventLoop::quit);
        connect(reply, static_cast<void (QNetworkReply::*)(QNetworkReply::NetworkError)>(&QNetworkReply::error), &loop, &QEventLoop::quit);
        timer.start(timeout*1000);

        loop.exec();

        reply->deleteLater();

        if(reply->error() != QNetworkReply::NoError)
        {
            return QByteArray();
        }

        return reply->readAll();
    });
    watcher->setFuture(furture);
}

bool FMPePayPrivate::HttpPost(QJsonObject& outjson, QJsonObject json, QString &error, int timeout)
{
    Q_Q(FMPePay);
    QEventLoop loop;
    QTimer timer;

    QSslConfiguration config;
    QList<QSslCertificate> certs = QSslCertificate::fromPath(qApp->applicationDirPath() + "/client01.pem");
    config.setPeerVerifyMode(QSslSocket::VerifyNone);
    config.setProtocol(QSsl::SslV3);
    config.setCaCertificates(certs);

    QNetworkAccessManager manger;
    QNetworkRequest request(q->_url);

    request.setSslConfiguration(config);
    request.setRawHeader("Content-Type","text/json");

    QNetworkReply* reply = manger.post(request, QJsonDocument(json).toJson());

    connect(&timer, &QTimer::timeout, &loop, &QEventLoop::quit);
    connect(&manger, &QNetworkAccessManager::finished, &loop, &QEventLoop::quit);
    connect(reply, static_cast<void (QNetworkReply::*)(QNetworkReply::NetworkError)>(&QNetworkReply::error), &loop, &QEventLoop::quit);
    timer.start(timeout*1000);

    loop.exec();

    reply->deleteLater();

    if(reply->error() != QNetworkReply::NoError)
    {
        error = QString::fromLocal8Bit("网络异常");
        return false;
    }

    if(!CheckReturnJson(reply->readAll(), outjson))
    {
        error = QString::fromLocal8Bit("返回数据错误");
        return false;
    }

    FMP_INFO() << outjson;

    if(outjson[FMP_RPAY_PAY_RETURN_STATUSCODE].toInt() == 100)
       return true;

    if(outjson.contains(FMP_RPAY_PAY_RETURN_MSG))
        error = outjson[FMP_RPAY_PAY_RETURN_MSG].toString() + QString("[%1]").arg(outjson[FMP_RPAY_PAY_RETURN_STATUSCODE].toInt());
    else
        error = QString::fromLocal8Bit("未定义错误") + QString("[%1]").arg(outjson[FMP_RPAY_PAY_RETURN_STATUSCODE].toInt());
    return false;

}

bool FMPePayPrivate::CheckReturnJson(QByteArray data, QJsonObject &returnjson)
{
    QJsonParseError json_error;
    QJsonDocument doc = QJsonDocument::fromJson( data, &json_error);

    if(json_error.error != QJsonParseError::NoError || !doc.isObject())
    {
        return false;
    }
    returnjson = doc.object();

    FMP_INFO() << "get return json : " << returnjson;

    return true;
}

void FMPePayPrivate::SetBasicInfo(QVariantHash hash)
{
    if(_payDialog != NULL)
        _payDialog->setBasicInfo(hash);
}

void FMPePayPrivate::GetCheckMode(QString sum)
{
    QString sql = QString("fmId like '%%%1%%' or pay_transId like '%%%1%%'").arg(sum);
    _model->setFilter(sql);
    _model->select();
}

void FMPePayPrivate::GetMode()
{
    _model->setFilter(QString(""));
    _model->select();
}


void FMPePayPrivate::ControlRefundJson(QString sum, QString code)
{
    Q_Q(FMPePay);

    QtConcurrent::run( [q, sum, code, this ]()
    {
        QString ebcode;
        QString transid;
        QStringList keylist;
        QSqlQuery query;
        keylist.append(SQL_KEY_EBCODE);
        keylist.append(SQL_KEY_TRANSID);
        if(_reverse_flag)
        {
            emit error(QString::fromLocal8Bit("网络连接异常(冲正...)"));
            return ;
        }

        if(!((code[0] >= 'a' && code[0] <= 'z') || (code[0] >= 'A' && code[0] <= 'Z')))
        {
            if(!_db->find(q->_table, query, keylist, QString(QString(SQL_KEY_PAYTRANSID) + " = '%1'").arg(code)) || !query.next())
            {
                emit error(QString::fromLocal8Bit("交易记录不存在"));
                return ;
            }else
            {
                ebcode = query.value(0).toString();
                transid = query.value(1).toString();
            }
        }

        if(!GetRefundJson(sum, code, ebcode, transid))
        {
            emit error(QString::fromLocal8Bit("获取门店信息失败"));
            return ;
        }

        FMP_INFO() << "refund json : " << _current_json;

        QString errors;
        QJsonObject outjson;

        if(!HttpPost(outjson, _current_json ,errors, q->_time_out))
        {
           emit error(errors);
        }
        else
        {
           QVariantHash hash;
           QSqlQuery tmpquery;
           QStringList tmpkeylist;
           tmpkeylist << SQL_KEY_PAYTRANSID << SQL_KEY_FMID << SQL_KEY_PAYID;

           hash.insert(SQL_KEY_ISREFUND, true);
           hash.insert(SQL_KEY_REFUND_DATE, QDateTime::currentDateTime().toString("yyyy-MM-dd"));

           if(!_db->update(q->_table, hash, QString("pay_transId = '%1' or fmId = '%2'").arg(code).arg(code)))
           {
                FMP_ERROR() << "refund data update failed";
           }

           if(!_db->find(q->_table, tmpquery, tmpkeylist,  QString("pay_transId = '%1' or fmId = '%2'").arg(code).arg(code)) || !tmpquery.next())
           {
               FMP_ERROR() << "refund data update failed";

               outjson.insert(SQL_KEY_PAYTRANSID, code);
               outjson.insert(SQL_KEY_FMID, code);
               outjson.insert(SQL_KEY_PAYID, QString::fromLocal8Bit("未知"));
               outjson.insert(SQL_KEY_TOTALAMOUNT, sum);
           }
           else
           {
               outjson.insert(SQL_KEY_PAYTRANSID, tmpquery.value(0).toString());
               outjson.insert(SQL_KEY_FMID, tmpquery.value(1).toString());
               outjson.insert(SQL_KEY_PAYID, tmpquery.value(2).toString());
               outjson.insert(SQL_KEY_TOTALAMOUNT, sum);
           }

           FMP_INFO() << "refund success view json : " << outjson;

           _model->setFilter(QString(""));
           _model->select();

           emit finished(outjson);
        }

    });
}

void FMPePayPrivate::ControlReverseJson()
{
    _reverse_flag = true;

    GetReverseJson();

    qDebug() << "using network send Reverse data to server";
    qDebug() << _current_json;
}

bool FMPePayPrivate::GetPayJson(const QString& sum, const QString& code)
{

    _current_json = QJsonObject::fromVariantMap( QVariantMap() );

    QJsonObject transaction;
    QJsonArray transactionarry;


    /**
     * settings get store infomation(or return false)
     **/
    qDebug() << "get store infomation from settings";

    int ver = 2;

    transaction.insert(FMP_EPAY_TRANSTRACTION_CODE,  code);
    transaction.insert(FMP_EPAY_TRANSTRACTION_AMOUNT, (int)((sum.toDouble() + 0.005) * 100));

    transactionarry.append( transaction);

    _current_json.insert( FMP_EPAY_VER, ver);
    _current_json.insert( FMP_EPAY_REQUESTTYPE, 72);
    _current_json.insert( FMP_EPAY_PARTNERID, q->_partner_id.toInt());
    _current_json.insert( FMP_EPAY_BUSINESSDATE, q->_businessdate);
    _current_json.insert( FMP_EPAY_CLIENTREQCOUNT, (int)((++s_ClientReqCount)%=10000000));
    _current_json.insert( FMP_EPAY_STOREID, q->_store_id);
    _current_json.insert( FMP_EPAY_STATIONID, q->_station_id);
    _current_json.insert( FMP_EPAY_OPERATORID, q->_operator_id);
    _current_json.insert( FMP_EPAY_TRANSID, QDateTime::currentDateTime().toString("yyyyMMddhhmmsszzz"));
    _current_json.insert( FMP_EPAY_TRANSTRACTION, transactionarry);

    return true;
}

bool FMPePayPrivate::GetRefundJson(const QString &sum, const QString &code, QString ebcode, QString transid)
{
    Q_Q(FMPePay);
    _current_json = QJsonObject::fromVariantMap( QVariantMap() );

    QJsonObject transaction;
    QJsonArray transactionarry;


    /**
     * settings get store infomation(or return false)
     **/
    qDebug() << "get store infomation from settings";

    int ver = 2;

    if((code[0] >= 'a' && code[0] <= 'z') || (code[0] >= 'A' && code[0] <= 'Z'))
    {
        transaction.insert(FMP_EPAY_REFUND_TRANSTRACTION_FMID,  code);
        transaction.insert(FMP_EPAY_REFUND_TRANSTRACTION_AMOUNT, (int)((sum.toDouble() + 0.005) * 100));
        _current_json.insert( FMP_EPAY_TRANSID, QDateTime::currentDateTime().toString("yyyyMMddhhmmsszzz"));
    }else
    {
        transaction.insert(FMP_EPAY_REFUND_TRANSTRACTION_EBCODE,  ebcode);
        transaction.insert(FMP_EPAY_REFUND_TRANSTRACTION_TRANSID,  code);
        transaction.insert(FMP_EPAY_REFUND_TRANSTRACTION_AMOUNT, (int)((sum.toDouble() + 0.005) * 100));
        _current_json.insert( FMP_EPAY_TRANSID, transid);
    }

    transactionarry.append( transaction);

    _current_json.insert( FMP_EPAY_VER, ver);
    _current_json.insert( FMP_EPAY_REQUESTTYPE, 62);
    _current_json.insert( FMP_EPAY_PARTNERID, q->_partner_id.toInt());
    _current_json.insert( FMP_EPAY_CLIENTREQCOUNT, (int)((++s_ClientReqCount)%=10000000));
    _current_json.insert( FMP_EPAY_STOREID, q->_store_id);
    _current_json.insert( FMP_EPAY_STATIONID, q->_station_id);
    _current_json.insert( FMP_EPAY_OPERATORID, q->_operator_id);
    _current_json.insert( FMP_EPAY_TRANSTRACTION, transactionarry);

    return true;
}

void FMPePayPrivate::GetReverseJson()
{
    _current_json[FMP_EPAY_REQUESTTYPE] = 3;
}
